/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.NodeManager;
import org.apache.iotdb.confignode.manager.PartitionManager;
import org.apache.iotdb.confignode.manager.load.balancer.router.IRouter;
import org.apache.iotdb.confignode.manager.load.balancer.router.LazyGreedyRouter;
import org.apache.iotdb.confignode.manager.load.balancer.router.LeaderRouter;
import org.apache.iotdb.confignode.manager.load.balancer.router.LoadScoreGreedyRouter;

public class RouteBalancer {
    public static final String LEADER_POLICY = "leader";
    public static final String GREEDY_POLICY = "greedy";
    private final IManager configManager;
    private final LazyGreedyRouter lazyGreedyRouter;

    public RouteBalancer(IManager configManager) {
        this.configManager = configManager;
        this.lazyGreedyRouter = new LazyGreedyRouter();
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> genLatestRegionRouteMap(List<TRegionReplicaSet> regionReplicaSets) {
        ArrayList<TRegionReplicaSet> schemaRegionGroups = new ArrayList<TRegionReplicaSet>();
        ArrayList<TRegionReplicaSet> dataRegionGroups = new ArrayList<TRegionReplicaSet>();
        regionReplicaSets.forEach(regionReplicaSet -> {
            switch (regionReplicaSet.getRegionId().getType()) {
                case SchemaRegion: {
                    schemaRegionGroups.add((TRegionReplicaSet)regionReplicaSet);
                    break;
                }
                case DataRegion: {
                    dataRegionGroups.add((TRegionReplicaSet)regionReplicaSet);
                }
            }
        });
        Map<TConsensusGroupId, TRegionReplicaSet> result = this.genRouter(TConsensusGroupType.SchemaRegion).genLatestRegionRouteMap(schemaRegionGroups);
        result.putAll(this.genRouter(TConsensusGroupType.DataRegion).genLatestRegionRouteMap(dataRegionGroups));
        return result;
    }

    private IRouter genRouter(TConsensusGroupType groupType) {
        String policy = ConfigNodeDescriptor.getInstance().getConf().getRoutingPolicy();
        switch (groupType) {
            case SchemaRegion: {
                if (LEADER_POLICY.equals(policy)) {
                    return new LeaderRouter(this.getPartitionManager().getAllLeadership(), this.getNodeManager().getAllLoadScores());
                }
                return new LoadScoreGreedyRouter(this.getNodeManager().getAllLoadScores());
            }
        }
        if (ConfigNodeDescriptor.getInstance().getConf().getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.multileader.MultiLeaderConsensus")) {
            this.lazyGreedyRouter.updateDisabledDataNodes(this.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Unknown, NodeStatus.Removing, NodeStatus.Error, NodeStatus.ReadOnly));
            return this.lazyGreedyRouter;
        }
        if (LEADER_POLICY.equals(policy)) {
            return new LeaderRouter(this.getPartitionManager().getAllLeadership(), this.getNodeManager().getAllLoadScores());
        }
        return new LoadScoreGreedyRouter(this.getNodeManager().getAllLoadScores());
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> getRouteMap() {
        return this.lazyGreedyRouter.getRouteMap();
    }
}

