/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class SetSchemaReplicationFactorPlan
extends ConfigPhysicalPlan {
    private String storageGroup;
    private int schemaReplicationFactor;

    public SetSchemaReplicationFactorPlan() {
        super(ConfigPhysicalPlanType.SetSchemaReplicationFactor);
    }

    public SetSchemaReplicationFactorPlan(String storageGroup, int schemaReplicationFactor) {
        this();
        this.storageGroup = storageGroup;
        this.schemaReplicationFactor = schemaReplicationFactor;
    }

    public String getStorageGroup() {
        return this.storageGroup;
    }

    public int getSchemaReplicationFactor() {
        return this.schemaReplicationFactor;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeInt(this.getType().ordinal());
        BasicStructureSerDeUtil.write((String)this.storageGroup, (DataOutputStream)stream);
        stream.writeInt(this.schemaReplicationFactor);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.storageGroup = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.schemaReplicationFactor = buffer.getInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetSchemaReplicationFactorPlan that = (SetSchemaReplicationFactorPlan)o;
        return this.schemaReplicationFactor == that.schemaReplicationFactor && this.storageGroup.equals(that.storageGroup);
    }

    public int hashCode() {
        return Objects.hash(this.storageGroup, this.schemaReplicationFactor);
    }
}

