/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.handlers.AbstractRetryHandler;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateRegionRouteMapHandler
extends AbstractRetryHandler
implements AsyncMethodCallback<TSStatus> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateRegionRouteMapHandler.class);

    public UpdateRegionRouteMapHandler(CountDownLatch countDownLatch, DataNodeRequestType requestType, TDataNodeLocation targetDataNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap) {
        super(countDownLatch, requestType, targetDataNode, dataNodeLocationMap);
    }

    public void onComplete(TSStatus status) {
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.dataNodeLocationMap.remove(this.targetDataNode.getDataNodeId());
            LOGGER.info("Successfully update the RegionRouteMap on DataNode: {}", (Object)this.targetDataNode.getDataNodeId());
        } else {
            LOGGER.error("Update RegionRouteMap on DataNode: {} failed", (Object)this.targetDataNode.getDataNodeId());
        }
        this.countDownLatch.countDown();
    }

    public void onError(Exception e) {
        LOGGER.error("Update RegionRouteMap on DataNode: {} failed", (Object)this.targetDataNode.getDataNodeId());
        this.countDownLatch.countDown();
    }
}

