/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.handlers.AbstractRetryHandler;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateRegionHandler
extends AbstractRetryHandler
implements AsyncMethodCallback<TSStatus> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateRegionHandler.class);
    private final int index;
    private final TConsensusGroupId consensusGroupId;

    public CreateRegionHandler(CountDownLatch latch, DataNodeRequestType requestType, TConsensusGroupId consensusGroupId, TDataNodeLocation targetDataNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap, int index) {
        super(latch, requestType, targetDataNode, dataNodeLocationMap);
        this.consensusGroupId = consensusGroupId;
        this.index = index;
    }

    public void onComplete(TSStatus tsStatus) {
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.dataNodeLocationMap.remove(this.index);
            LOGGER.info(String.format("Successfully create %s on DataNode: %s", ConsensusGroupId.formatTConsensusGroupId((TConsensusGroupId)this.consensusGroupId), this.targetDataNode));
        } else {
            LOGGER.error(String.format("Create %s on DataNode: %s failed, %s", ConsensusGroupId.formatTConsensusGroupId((TConsensusGroupId)this.consensusGroupId), this.targetDataNode, tsStatus));
        }
        this.countDownLatch.countDown();
    }

    public void onError(Exception e) {
        LOGGER.error(String.format("Create %s on DataNode: %s failed, %s", ConsensusGroupId.formatTConsensusGroupId((TConsensusGroupId)this.consensusGroupId), this.targetDataNode, e));
        this.countDownLatch.countDown();
    }

    public TConsensusGroupId getConsensusGroupId() {
        return this.consensusGroupId;
    }
}

