/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.dropwizard.reporter;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.metrics.dropwizard.reporter.MetricType;
import org.apache.iotdb.metrics.dropwizard.reporter.PrometheusTextWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DropwizardMetricsExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardMetricsExporter.class);
    private final MetricRegistry metricRegistry;
    private final PrometheusTextWriter writer;

    public DropwizardMetricsExporter(MetricRegistry metricRegistry, PrometheusTextWriter writer) {
        this.metricRegistry = metricRegistry;
        this.writer = writer;
    }

    public void scrape() throws IOException {
        for (Map.Entry entry : this.metricRegistry.getGauges().entrySet()) {
            this.writeGauge((String)entry.getKey(), (Gauge)entry.getValue());
        }
        for (Map.Entry entry : this.metricRegistry.getCounters().entrySet()) {
            this.writeCounter((String)entry.getKey(), (Counter)entry.getValue());
        }
        for (Map.Entry entry : this.metricRegistry.getHistograms().entrySet()) {
            this.writeHistogram((String)entry.getKey(), (Histogram)entry.getValue());
        }
        for (Map.Entry entry : this.metricRegistry.getMeters().entrySet()) {
            this.writeMeter((String)entry.getKey(), (Meter)entry.getValue());
        }
        for (Map.Entry entry : this.metricRegistry.getTimers().entrySet()) {
            this.writeTimer((String)entry.getKey(), (Timer)entry.getValue());
        }
    }

    public void writeGauge(String name, Gauge<?> gauge) throws IOException {
        double value;
        String sanitizedName = DropwizardMetricsExporter.sanitizeMetricName(name);
        this.writer.writeHelp(sanitizedName, DropwizardMetricsExporter.getHelpMessage(name, gauge));
        this.writer.writeType(sanitizedName, MetricType.GAUGE);
        Object obj = gauge.getValue();
        if (obj instanceof Number) {
            value = ((Number)obj).doubleValue();
        } else if (obj instanceof Boolean) {
            value = (Boolean)obj != false ? 1.0 : 0.0;
        } else {
            return;
        }
        this.writer.writeSample(sanitizedName, this.emptyMap(), value);
    }

    public void writeCounter(String dropwizardName, Counter counter) throws IOException {
        String name = DropwizardMetricsExporter.sanitizeMetricName(dropwizardName);
        this.writer.writeHelp(name, DropwizardMetricsExporter.getHelpMessage(dropwizardName, (Metric)counter));
        this.writer.writeType(name, MetricType.GAUGE);
        this.writer.writeSample(name, this.emptyMap(), counter.getCount());
    }

    public void writeHistogram(String dropwizardName, Histogram histogram) throws IOException {
        this.writeSnapshotAndCount(dropwizardName, histogram.getSnapshot(), histogram.getCount(), 1.0, MetricType.SUMMARY, DropwizardMetricsExporter.getHelpMessage(dropwizardName, (Metric)histogram));
    }

    private void writeSnapshotAndCount(String dropwizardName, Snapshot snapshot, long count, double factor, MetricType type, String helpMessage) throws IOException {
        String name = DropwizardMetricsExporter.sanitizeMetricName(dropwizardName);
        this.writer.writeHelp(name, helpMessage);
        this.writer.writeType(name, type);
        this.writer.writeSample(name, this.mapOf("quantile", "0.5"), snapshot.getMedian() * factor);
        this.writer.writeSample(name, this.mapOf("quantile", "0.75"), snapshot.get75thPercentile() * factor);
        this.writer.writeSample(name, this.mapOf("quantile", "0.95"), snapshot.get95thPercentile() * factor);
        this.writer.writeSample(name, this.mapOf("quantile", "0.98"), snapshot.get98thPercentile() * factor);
        this.writer.writeSample(name, this.mapOf("quantile", "0.99"), snapshot.get99thPercentile() * factor);
        this.writer.writeSample(name, this.mapOf("quantile", "0.999"), snapshot.get999thPercentile() * factor);
        this.writer.writeSample(name + "_min", this.emptyMap(), snapshot.getMin());
        this.writer.writeSample(name + "_max", this.emptyMap(), snapshot.getMax());
        this.writer.writeSample(name + "_median", this.emptyMap(), snapshot.getMedian());
        this.writer.writeSample(name + "_mean", this.emptyMap(), snapshot.getMean());
        this.writer.writeSample(name + "_stddev", this.emptyMap(), snapshot.getStdDev());
        this.writer.writeSample(name + "_count", this.emptyMap(), count);
    }

    public void writeTimer(String dropwizardName, Timer timer) throws IOException {
        this.writeSnapshotAndCount(dropwizardName, timer.getSnapshot(), timer.getCount(), 1.0 / (double)TimeUnit.SECONDS.toNanos(1L), MetricType.SUMMARY, DropwizardMetricsExporter.getHelpMessage(dropwizardName, (Metric)timer));
        this.writeMetered(dropwizardName, (Metered)timer);
    }

    public void writeMeter(String dropwizardName, Meter meter) throws IOException {
        String name = DropwizardMetricsExporter.sanitizeMetricName(dropwizardName) + "_total";
        this.writer.writeHelp(name, DropwizardMetricsExporter.getHelpMessage(dropwizardName, (Metric)meter));
        this.writer.writeType(name, MetricType.COUNTER);
        this.writer.writeSample(name, this.emptyMap(), meter.getCount());
        this.writeMetered(dropwizardName, (Metered)meter);
    }

    private void writeMetered(String dropwizardName, Metered metered) throws IOException {
        String name = DropwizardMetricsExporter.sanitizeMetricName(dropwizardName);
        this.writer.writeSample(name, this.mapOf("rate", "m1"), metered.getOneMinuteRate());
        this.writer.writeSample(name, this.mapOf("rate", "m5"), metered.getFiveMinuteRate());
        this.writer.writeSample(name, this.mapOf("rate", "m15"), metered.getFifteenMinuteRate());
        this.writer.writeSample(name, this.mapOf("rate", "mean"), metered.getMeanRate());
    }

    private Map<String, String> mapOf(String key, String value) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(key, value);
        return result;
    }

    private Map<String, String> emptyMap() {
        return Collections.emptyMap();
    }

    private static String getHelpMessage(String metricName, Metric metric) {
        return String.format("Generated from Dropwizard metric import (metric=%s, type=%s)", metricName, metric.getClass().getName());
    }

    static String sanitizeMetricName(String dropwizardName) {
        return dropwizardName.replaceAll("[^a-zA-Z0-9:_\\]\\[]", "_");
    }
}

