/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.dropwizard;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.UniformReservoir;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.CachedThreadStatesGaugeSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.JvmAttributeGaugeSet;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.ToLongFunction;
import org.apache.iotdb.metrics.MetricManager;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.dropwizard.MetricName;
import org.apache.iotdb.metrics.dropwizard.type.DropwizardAutoGauge;
import org.apache.iotdb.metrics.dropwizard.type.DropwizardCounter;
import org.apache.iotdb.metrics.dropwizard.type.DropwizardGauge;
import org.apache.iotdb.metrics.dropwizard.type.DropwizardHistogram;
import org.apache.iotdb.metrics.dropwizard.type.DropwizardRate;
import org.apache.iotdb.metrics.dropwizard.type.DropwizardTimer;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.type.IMetric;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.PredefinedMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardMetricManager
implements MetricManager {
    private static final Logger logger = LoggerFactory.getLogger(DropwizardMetricManager.class);
    Map<MetricName, IMetric> currentMeters;
    boolean isEnable;
    MetricRegistry metricRegistry;
    MetricConfig metricConfig = MetricConfigDescriptor.getInstance().getMetricConfig();
    MetricRegistry.MetricSupplier<com.codahale.metrics.Timer> timerMetricSupplier = () -> new com.codahale.metrics.Timer((Reservoir)new UniformReservoir());
    MetricRegistry.MetricSupplier<Histogram> histogramMetricSupplier = () -> new Histogram((Reservoir)new UniformReservoir());

    public DropwizardMetricManager() {
        this.metricRegistry = new MetricRegistry();
        this.isEnable = this.metricConfig.getEnableMetric();
        this.currentMeters = new ConcurrentHashMap<MetricName, IMetric>();
    }

    public Counter getOrCreateCounter(String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return DoNothingMetricManager.doNothingCounter;
        }
        MetricName name = new MetricName(metric, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(name, key -> new DropwizardCounter(this.metricRegistry.counter(name.toFlatString())));
        if (m instanceof Counter) {
            return (Counter)m;
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }

    public <T> Gauge getOrCreateAutoGauge(String metric, MetricLevel metricLevel, T obj, ToLongFunction<T> mapper, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return DoNothingMetricManager.doNothingGauge;
        }
        MetricName name = new MetricName(metric, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(name, key -> {
            DropwizardAutoGauge<Object> dropwizardGauge = new DropwizardAutoGauge<Object>(obj, mapper);
            this.metricRegistry.register(name.toFlatString(), dropwizardGauge);
            return dropwizardGauge;
        });
        if (m instanceof Gauge) {
            return (Gauge)m;
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }

    public Gauge getOrCreateGauge(String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return DoNothingMetricManager.doNothingGauge;
        }
        MetricName name = new MetricName(metric, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(name, key -> {
            DropwizardGauge dropwizardGauge = new DropwizardGauge();
            this.metricRegistry.register(name.toFlatString(), dropwizardGauge.getDropwizardCachedGauge());
            return dropwizardGauge;
        });
        if (m instanceof Gauge) {
            return (Gauge)m;
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }

    public Rate getOrCreateRate(String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return DoNothingMetricManager.doNothingRate;
        }
        MetricName name = new MetricName(metric, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(name, key -> new DropwizardRate(this.metricRegistry.meter(name.toFlatString())));
        if (m instanceof Rate) {
            return (Rate)m;
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }

    public org.apache.iotdb.metrics.type.Histogram getOrCreateHistogram(String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return DoNothingMetricManager.doNothingHistogram;
        }
        MetricName name = new MetricName(metric, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(name, key -> new DropwizardHistogram(this.metricRegistry.histogram(name.toFlatString(), this.histogramMetricSupplier)));
        if (m instanceof org.apache.iotdb.metrics.type.Histogram) {
            return (org.apache.iotdb.metrics.type.Histogram)m;
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }

    public Timer getOrCreateTimer(String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable()) {
            return DoNothingMetricManager.doNothingTimer;
        }
        MetricName name = new MetricName(metric, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(name, key -> new DropwizardTimer(this.metricRegistry.timer(name.toFlatString(), this.timerMetricSupplier)));
        if (m instanceof Timer) {
            return (Timer)m;
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }

    public void count(long delta, String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return;
        }
        MetricName name = new MetricName(metric, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(name, key -> new DropwizardCounter(this.metricRegistry.counter(name.toFlatString())));
        if (m instanceof Counter) {
            ((Counter)m).inc(delta);
            return;
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }

    public void gauge(long value, String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return;
        }
        MetricName name = new MetricName(metric, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(name, key -> {
            DropwizardGauge dropwizardGauge = new DropwizardGauge();
            this.metricRegistry.register(name.toFlatString(), dropwizardGauge.getDropwizardCachedGauge());
            return dropwizardGauge;
        });
        if (m instanceof Gauge) {
            ((Gauge)m).set(value);
            return;
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }

    public void rate(long value, String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return;
        }
        MetricName name = new MetricName(metric, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(name, key -> new DropwizardRate(this.metricRegistry.meter(name.toFlatString())));
        if (m instanceof Rate) {
            ((Rate)m).mark(value);
            return;
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }

    public void histogram(long value, String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return;
        }
        MetricName name = new MetricName(metric, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(name, key -> new DropwizardHistogram(this.metricRegistry.histogram(name.toFlatString(), this.histogramMetricSupplier)));
        if (m instanceof org.apache.iotdb.metrics.type.Histogram) {
            ((org.apache.iotdb.metrics.type.Histogram)m).update(value);
            return;
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }

    public void timer(long delta, TimeUnit timeUnit, String metric, MetricLevel metricLevel, String ... tags) {
        if (!this.isEnable(metricLevel)) {
            return;
        }
        MetricName name = new MetricName(metric, metricLevel, tags);
        IMetric m = this.currentMeters.computeIfAbsent(name, key -> new DropwizardTimer(this.metricRegistry.timer(name.toFlatString(), this.timerMetricSupplier)));
        if (m instanceof Timer) {
            ((Timer)m).update(delta, timeUnit);
            return;
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }

    public void removeCounter(String metric, String ... tags) {
        if (!this.isEnable()) {
            return;
        }
        MetricName name = new MetricName(metric, tags);
        this.metricRegistry.remove(name.toFlatString());
        this.currentMeters.remove(name);
    }

    public void removeGauge(String metric, String ... tags) {
        if (!this.isEnable()) {
            return;
        }
        MetricName name = new MetricName(metric, tags);
        this.metricRegistry.remove(name.toFlatString());
        this.currentMeters.remove(name);
    }

    public void removeRate(String metric, String ... tags) {
        if (!this.isEnable()) {
            return;
        }
        MetricName name = new MetricName(metric, tags);
        this.metricRegistry.remove(name.toFlatString());
        this.currentMeters.remove(name);
    }

    public void removeHistogram(String metric, String ... tags) {
        if (!this.isEnable()) {
            return;
        }
        MetricName name = new MetricName(metric, tags);
        this.metricRegistry.remove(name.toFlatString());
        this.currentMeters.remove(name);
    }

    public void removeTimer(String metric, String ... tags) {
        if (!this.isEnable()) {
            return;
        }
        MetricName name = new MetricName(metric, tags);
        this.metricRegistry.remove(name.toFlatString());
        this.currentMeters.remove(name);
    }

    public List<String[]> getAllMetricKeys() {
        if (!this.isEnable()) {
            return Collections.emptyList();
        }
        ArrayList<String[]> keys = new ArrayList<String[]>(this.currentMeters.size());
        this.currentMeters.keySet().forEach(k -> keys.add(k.toStringArray()));
        return keys;
    }

    public Map<String[], Counter> getAllCounters() {
        HashMap<String[], Counter> counterMap = new HashMap<String[], Counter>();
        for (Map.Entry<MetricName, IMetric> entry : this.currentMeters.entrySet()) {
            if (!(entry.getValue() instanceof Counter)) continue;
            counterMap.put(entry.getKey().toStringArray(), (Counter)entry.getValue());
        }
        return counterMap;
    }

    public Map<String[], Gauge> getAllGauges() {
        HashMap<String[], Gauge> gaugeMap = new HashMap<String[], Gauge>();
        for (Map.Entry<MetricName, IMetric> entry : this.currentMeters.entrySet()) {
            if (!(entry.getValue() instanceof Gauge)) continue;
            gaugeMap.put(entry.getKey().toStringArray(), (Gauge)entry.getValue());
        }
        return gaugeMap;
    }

    public Map<String[], Rate> getAllRates() {
        HashMap<String[], Rate> rateMap = new HashMap<String[], Rate>();
        for (Map.Entry<MetricName, IMetric> entry : this.currentMeters.entrySet()) {
            if (!(entry.getValue() instanceof Rate)) continue;
            rateMap.put(entry.getKey().toStringArray(), (Rate)entry.getValue());
        }
        return rateMap;
    }

    public Map<String[], org.apache.iotdb.metrics.type.Histogram> getAllHistograms() {
        HashMap<String[], org.apache.iotdb.metrics.type.Histogram> histogramMap = new HashMap<String[], org.apache.iotdb.metrics.type.Histogram>();
        for (Map.Entry<MetricName, IMetric> entry : this.currentMeters.entrySet()) {
            if (!(entry.getValue() instanceof org.apache.iotdb.metrics.type.Histogram)) continue;
            histogramMap.put(entry.getKey().toStringArray(), (org.apache.iotdb.metrics.type.Histogram)entry.getValue());
        }
        return histogramMap;
    }

    public Map<String[], Timer> getAllTimers() {
        HashMap<String[], Timer> timerMap = new HashMap<String[], Timer>();
        for (Map.Entry<MetricName, IMetric> entry : this.currentMeters.entrySet()) {
            if (!(entry.getValue() instanceof Timer)) continue;
            timerMap.put(entry.getKey().toStringArray(), (Timer)entry.getValue());
        }
        return timerMap;
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    public boolean isEnable(MetricLevel metricLevel) {
        return this.isEnable() && MetricLevel.higherOrEqual((MetricLevel)metricLevel, (MetricLevel)this.metricConfig.getMetricLevel());
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void enablePredefinedMetric(PredefinedMetric metric) {
        if (!this.isEnable()) {
            return;
        }
        switch (metric) {
            case JVM: {
                this.enableJvmMetrics();
                break;
            }
            default: {
                logger.warn("Unsupported metric type {}", (Object)metric);
            }
        }
    }

    private void enableJvmMetrics() {
        if (!this.isEnable()) {
            return;
        }
        this.metricRegistry.registerAll((MetricSet)new JvmAttributeGaugeSet());
        this.metricRegistry.registerAll((MetricSet)new GarbageCollectorMetricSet());
        this.metricRegistry.registerAll((MetricSet)new ClassLoadingGaugeSet());
        this.metricRegistry.registerAll((MetricSet)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        this.metricRegistry.registerAll((MetricSet)new CachedThreadStatesGaugeSet(5L, TimeUnit.MILLISECONDS));
    }

    public boolean init() {
        return true;
    }

    public boolean stop() {
        this.isEnable = this.metricConfig.getEnableMetric();
        this.metricRegistry.removeMatching(MetricFilter.ALL);
        this.currentMeters = new ConcurrentHashMap<MetricName, IMetric>();
        return true;
    }
}

