/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.template;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.exception.metadata.DuplicatedTemplateException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.UndefinedTemplateException;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.utils.MetaFormatUtils;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.apache.iotdb.db.qp.physical.sys.AppendTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.DropTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.PruneTemplatePlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public class TemplateManager {
    private Map<String, Template> templateMap = new ConcurrentHashMap<String, Template>();

    public static TemplateManager getInstance() {
        return TemplateManagerHolder.INSTANCE;
    }

    public static TemplateManager getNewInstanceForTest() {
        return new TemplateManager();
    }

    private TemplateManager() {
    }

    public void createSchemaTemplate(CreateTemplatePlan plan) throws MetadataException {
        if (plan.getSchemaNames() != null) {
            for (String string : plan.getSchemaNames()) {
                MetaFormatUtils.checkNodeName(string);
            }
        }
        for (List list : plan.getMeasurements()) {
            for (String measurement : list) {
                MetaFormatUtils.checkTimeseries(new PartialPath(measurement));
            }
        }
        Template template = new Template(plan);
        if (this.templateMap.putIfAbsent(plan.getName(), template) != null) {
            throw new MetadataException("Duplicated template name: " + plan.getName());
        }
    }

    public void dropSchemaTemplate(DropTemplatePlan plan) {
        this.templateMap.remove(plan.getName());
    }

    public void appendSchemaTemplate(AppendTemplatePlan plan) throws MetadataException {
        String templateName = plan.getName();
        Template temp = this.templateMap.getOrDefault(templateName, null);
        if (temp != null) {
            String[] measurements = plan.getMeasurements().toArray(new String[0]);
            TSDataType[] dataTypes = new TSDataType[measurements.length];
            TSEncoding[] encodings = new TSEncoding[measurements.length];
            CompressionType[] compressionTypes = new CompressionType[measurements.length];
            for (int i = 0; i < measurements.length; ++i) {
                dataTypes[i] = plan.getDataTypes().get(i);
                encodings[i] = plan.getEncodings().get(i);
                compressionTypes[i] = plan.getCompressors().get(i);
            }
            if (plan.isAligned()) {
                temp.addAlignedMeasurements(measurements, dataTypes, encodings, compressionTypes);
            } else {
                temp.addUnalignedMeasurements(measurements, dataTypes, encodings, compressionTypes);
            }
        } else {
            throw new MetadataException("Template does not exists:" + plan.getName());
        }
    }

    public void pruneSchemaTemplate(PruneTemplatePlan plan) throws MetadataException {
        String templateName = plan.getName();
        Template temp = this.templateMap.getOrDefault(templateName, null);
        if (temp != null) {
            for (int i = 0; i < plan.getPrunedMeasurements().size(); ++i) {
                temp.deleteSeriesCascade(plan.getPrunedMeasurements().get(i));
            }
        } else {
            throw new MetadataException("Template does not exists:" + plan.getName());
        }
    }

    public Template getTemplate(String templateName) throws UndefinedTemplateException {
        Template template = this.templateMap.get(templateName);
        if (template == null) {
            throw new UndefinedTemplateException(templateName);
        }
        return template;
    }

    public void setTemplateMap(Map<String, Template> templateMap) {
        this.templateMap.clear();
        for (Map.Entry<String, Template> templateEntry : templateMap.entrySet()) {
            this.templateMap.put(templateEntry.getKey(), templateEntry.getValue());
        }
    }

    public Map<String, Template> getTemplateMap() {
        return this.templateMap;
    }

    public Set<String> getAllTemplateName() {
        return this.templateMap.keySet();
    }

    public void checkTemplateCompatible(Template template, IMNode node) throws MetadataException {
        if (node.getSchemaTemplate() != null) {
            if (node.getSchemaTemplate().equals(template)) {
                throw new DuplicatedTemplateException(template.getName());
            }
            throw new MetadataException("Specified node already has template");
        }
        for (String measurementPath : template.getSchemaMap().keySet()) {
            String directNodeName = MetaUtils.splitPathToDetachedPath(measurementPath)[0];
            if (!node.hasChild(directNodeName)) continue;
            throw new MetadataException("Node name " + directNodeName + " in template has conflict with node's child " + node.getFullPath() + "." + directNodeName);
        }
        if (node.isEntity() && node.getAsEntityMNode().isAligned() != template.isDirectAligned()) {
            for (IMNode dNode : template.getDirectNodes()) {
                if (!dNode.isMeasurement()) continue;
                throw new MetadataException(String.format("Template[%s] and mounted node[%s] has different alignment.", template.getName(), node.getFullPath() + '.' + dNode.getFullPath()));
            }
        }
    }

    public void clear() {
        this.templateMap.clear();
    }

    private static class TemplateManagerHolder {
        private static final TemplateManager INSTANCE = new TemplateManager();

        private TemplateManagerHolder() {
        }
    }
}

