/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.writer;

import java.io.IOException;
import org.apache.iotdb.db.engine.compaction.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class InnerSpaceCompactionWriter
extends AbstractCompactionWriter {
    private TsFileIOWriter fileWriter;
    private boolean isEmptyFile;
    private final TsFileResource targetTsFileResource;

    public InnerSpaceCompactionWriter(TsFileResource targetFileResource) throws IOException {
        this.fileWriter = new RestorableTsFileIOWriter(targetFileResource.getTsFile());
        this.isEmptyFile = true;
        this.targetTsFileResource = targetFileResource;
    }

    @Override
    public void startChunkGroup(String deviceId, boolean isAlign) throws IOException {
        this.fileWriter.startChunkGroup(deviceId);
        this.isAlign = isAlign;
        this.deviceId = deviceId;
    }

    @Override
    public void endChunkGroup() throws IOException {
        this.fileWriter.endChunkGroup();
    }

    @Override
    public void endMeasurement() throws IOException {
        this.writeRateLimit(this.chunkWriter.estimateMaxSeriesMemSize());
        this.chunkWriter.writeToFileWriter(this.fileWriter);
        this.chunkWriter = null;
    }

    @Override
    public void write(long timestamp, Object value) throws IOException {
        this.writeDataPoint(timestamp, value);
        this.updateDeviceStartAndEndTime(this.targetTsFileResource, timestamp);
        this.checkChunkSizeAndMayOpenANewChunk(this.fileWriter);
        this.isEmptyFile = false;
    }

    @Override
    public void write(long[] timestamps, Object values) {
    }

    @Override
    public void endFile() throws IOException {
        this.fileWriter.endFile();
        if (this.isEmptyFile) {
            this.fileWriter.getFile().delete();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fileWriter != null && this.fileWriter.canWrite()) {
            this.fileWriter.close();
        }
        this.chunkWriter = null;
        this.fileWriter = null;
    }
}

