/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.inner;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceList;
import org.apache.iotdb.db.rescon.TsFileResourceManager;
import org.apache.iotdb.tsfile.utils.TsFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnerSpaceCompactionExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");

    public static void handleException(String fullStorageGroupName, File logFile, TsFileResource targetTsFile, List<TsFileResource> selectedTsFileResourceList, TsFileManager tsFileManager, TsFileResourceList tsFileResourceList) {
        if (!logFile.exists()) {
            return;
        }
        boolean handleSuccess = true;
        ArrayList<TsFileResource> lostSourceFiles = new ArrayList<TsFileResource>();
        boolean allSourceFileExist = InnerSpaceCompactionExceptionHandler.checkAllSourceFilesExist(selectedTsFileResourceList, lostSourceFiles);
        if (allSourceFileExist) {
            handleSuccess = InnerSpaceCompactionExceptionHandler.handleWhenAllSourceFilesExist(fullStorageGroupName, targetTsFile, selectedTsFileResourceList, tsFileResourceList, tsFileManager, false);
        } else {
            LOGGER.info("{} [Compaction][ExceptionHandler] some source files {} is lost", (Object)fullStorageGroupName, lostSourceFiles);
            if (!targetTsFile.getTsFile().exists()) {
                LOGGER.warn("{} [Compaction][ExceptionHandler] target file {} does not exist either, do nothing. Set system to read-only", (Object)fullStorageGroupName, (Object)targetTsFile);
                IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
                handleSuccess = false;
            } else {
                handleSuccess = InnerSpaceCompactionExceptionHandler.handleWhenSomeSourceFilesLost(fullStorageGroupName, targetTsFile, selectedTsFileResourceList, lostSourceFiles);
            }
        }
        if (!handleSuccess) {
            LOGGER.error("{} [Compaction][ExceptionHandler] Failed to handle exception, set allowCompaction to false", (Object)fullStorageGroupName);
            tsFileManager.setAllowCompaction(false);
        } else {
            LOGGER.info("{} [Compaction][ExceptionHandler] Handle exception successfully, delete log file {}", (Object)fullStorageGroupName, (Object)logFile);
            try {
                FileUtils.delete((File)logFile);
            }
            catch (IOException e) {
                LOGGER.error("{} [Compaction][ExceptionHandler] Exception occurs while deleting log file {}, set allowCompaction to false", new Object[]{fullStorageGroupName, logFile, e});
                tsFileManager.setAllowCompaction(false);
            }
        }
    }

    private static boolean checkAllSourceFilesExist(List<TsFileResource> sourceFiles, List<TsFileResource> lostSourceFiles) {
        boolean allSourceFileExist = true;
        for (TsFileResource sourceTsFile : sourceFiles) {
            if (sourceTsFile.getTsFile().exists()) continue;
            allSourceFileExist = false;
            lostSourceFiles.add(sourceTsFile);
        }
        return allSourceFileExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean handleWhenAllSourceFilesExist(String fullStorageGroupName, TsFileResource targetTsFile, List<TsFileResource> selectedTsFileResourceList, TsFileResourceList tsFileResourceList, TsFileManager tsFileManager, boolean isRecover) {
        try {
            TsFileResource tmpTargetTsFile;
            LOGGER.info("{} [Compaction][ExceptionHandler] all source files {} exists, delete target file {}", new Object[]{fullStorageGroupName, selectedTsFileResourceList, targetTsFile});
            if (targetTsFile.getTsFilePath().endsWith(".inner")) {
                tmpTargetTsFile = targetTsFile;
                targetTsFile = new TsFileResource(new File(tmpTargetTsFile.getTsFilePath().replace(".inner", ".tsfile")));
            } else {
                tmpTargetTsFile = new TsFileResource(new File(targetTsFile.getTsFilePath().replace(".tsfile", ".inner")));
            }
            if (!tmpTargetTsFile.remove()) {
                LOGGER.warn("{} [Compaction][ExceptionHandler] failed to remove target file {}", (Object)fullStorageGroupName, (Object)tmpTargetTsFile);
                return false;
            }
            if (!isRecover) {
                tsFileManager.writeLock("InnerSpaceCompactionExceptionHandler");
                try {
                    if (targetTsFile.isFileInList()) {
                        tsFileResourceList.remove(targetTsFile);
                        TsFileResourceManager.getInstance().removeTsFileResource(targetTsFile);
                    }
                    for (TsFileResource tsFileResource : selectedTsFileResourceList) {
                        if (tsFileResource.isFileInList()) continue;
                        tsFileResourceList.keepOrderInsert(tsFileResource);
                        TsFileResourceManager.getInstance().registerSealedTsFileResource(tsFileResource);
                    }
                }
                finally {
                    tsFileManager.writeUnlock();
                }
            }
            targetTsFile.writeLock();
            try {
                if (!targetTsFile.remove()) {
                    LOGGER.error("{} [Compaction][ExceptionHandler] failed to remove target file {}", (Object)fullStorageGroupName, (Object)targetTsFile);
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                targetTsFile.writeUnlock();
            }
            CompactionUtils.deleteCompactionModsFile(selectedTsFileResourceList, Collections.emptyList());
            return true;
        }
        catch (Throwable e) {
            LOGGER.error("{} Exception occurs while handling exception, set allowCompaction to false", (Object)fullStorageGroupName, (Object)e);
            return false;
        }
    }

    private static boolean handleWhenSomeSourceFilesLost(String fullStorageGroupName, TsFileResource targetTsFile, List<TsFileResource> selectedTsFileResourceList, List<TsFileResource> lostSourceFiles) {
        boolean handleSuccess = true;
        try {
            if (TsFileUtils.isTsFileComplete((File)targetTsFile.getTsFile())) {
                LOGGER.info("{} [Compaction][ExceptionHandler] target file {} is complete, delete remaining source files", (Object)fullStorageGroupName, (Object)targetTsFile);
                for (TsFileResource sourceFile : selectedTsFileResourceList) {
                    if (sourceFile.remove()) continue;
                    LOGGER.error("{} [Compaction][ExceptionHandler] failed to remove source file {}", (Object)fullStorageGroupName, (Object)sourceFile);
                    handleSuccess = false;
                }
                CompactionUtils.deleteCompactionModsFile(selectedTsFileResourceList, Collections.emptyList());
            } else {
                LOGGER.error("{} [Compaction][ExceptionHandler] target file {} is not complete, and some source files {} is lost, do nothing. Set allowCompaction to false", new Object[]{fullStorageGroupName, targetTsFile, lostSourceFiles});
                IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
                handleSuccess = false;
            }
        }
        catch (Throwable e) {
            LOGGER.error("{} [Compaction][ExceptionHandler] Another exception occurs during handling exception", (Object)fullStorageGroupName, (Object)e);
            handleSuccess = false;
        }
        return handleSuccess;
    }
}

