/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cli.tool;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jline.console.ConsoleReader;
import me.tongfei.progressbar.ProgressBar;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.cli.tool.AbstractCsvTool;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.thrift.TException;

public class ImportCsv
extends AbstractCsvTool {
    private static final String FILE_ARGS = "f";
    private static final String FILE_NAME = "file or folder";
    private static final String FILE_SUFFIX = "csv";
    private static final String TSFILEDB_CLI_PREFIX = "ImportCsv";
    private static final String ERROR_INFO_STR = "csvInsertError.error";
    private static final String STRING_DATA_TYPE = "TEXT";
    private static final int BATCH_EXECUTE_COUNT = 100;
    private static String errorInsertInfo = "";
    private static boolean errorFlag;
    private static String IOTDB_CLI_HOME;
    private static int count;
    private static Statement statement;

    private static Options createOptions() {
        Options options = new Options();
        Option opHost = Option.builder((String)"h").longOpt("host").required().argName("host").hasArg().desc("Host Name (required)").build();
        options.addOption(opHost);
        Option opPort = Option.builder((String)"p").longOpt("port").required().argName("port").hasArg().desc("Port (required)").build();
        options.addOption(opPort);
        Option opUsername = Option.builder((String)"u").longOpt("username").required().argName("username").hasArg().desc("Username (required)").build();
        options.addOption(opUsername);
        Option opPassword = Option.builder((String)"pw").longOpt("password").optionalArg(true).argName("password").hasArg().desc("Password (optional)").build();
        options.addOption(opPassword);
        Option opFile = Option.builder((String)FILE_ARGS).required().argName(FILE_NAME).hasArg().desc("If input a file path, load a csv file, otherwise load all csv file under this directory (required)").build();
        options.addOption(opFile);
        Option opHelp = Option.builder((String)"help").longOpt("help").hasArg(false).desc("Display help information").build();
        options.addOption(opHelp);
        Option opTimeZone = Option.builder((String)"tz").argName("timeZone").hasArg().desc("Time Zone eg. +08:00 or -01:00 (optional)").build();
        options.addOption(opTimeZone);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadDataFromCSV(File file, int index) {
        int fileLine;
        statement = null;
        try {
            fileLine = ImportCsv.getFileLineCount(file);
        }
        catch (IOException e) {
            System.out.println("Failed to import file: " + file.getName());
            return;
        }
        File errorFile = new File(errorInsertInfo + index);
        if (!errorFile.exists()) {
            try {
                errorFile.createNewFile();
            }
            catch (IOException e) {
                System.out.println("Cannot create a errorFile because: " + e.getMessage());
                return;
            }
        }
        System.out.println("Start to import data from: " + file.getName());
        errorFlag = true;
        try (BufferedReader br = new BufferedReader(new FileReader(file));
             BufferedWriter bw = new BufferedWriter(new FileWriter(errorFile));
             ProgressBar pb = new ProgressBar("Import from: " + file.getName(), (long)fileLine);){
            pb.setExtraMessage("Importing...");
            String header = br.readLine();
            bw.write("From " + file.getAbsolutePath());
            bw.newLine();
            bw.newLine();
            bw.write(header);
            bw.newLine();
            bw.newLine();
            HashMap<String, ArrayList<Integer>> deviceToColumn = new HashMap<String, ArrayList<Integer>>();
            ArrayList<String> colInfo = new ArrayList<String>();
            ArrayList<String> headInfo = new ArrayList<String>();
            String[] strHeadInfo = header.split(",");
            if (strHeadInfo.length <= 1) {
                System.out.println("The CSV file " + file.getName() + " illegal, please check first line");
                return;
            }
            long startTime = System.currentTimeMillis();
            HashMap<String, String> timeseriesDataType = new HashMap<String, String>();
            boolean success = ImportCsv.queryDatabaseMeta(strHeadInfo, file, bw, timeseriesDataType, headInfo, deviceToColumn, colInfo);
            if (!success) {
                errorFlag = false;
                return;
            }
            statement = connection.createStatement();
            ArrayList<String> tmp = new ArrayList<String>();
            success = ImportCsv.readAndGenSqls(br, timeseriesDataType, deviceToColumn, colInfo, headInfo, bw, tmp, pb);
            if (!success) {
                return;
            }
            ImportCsv.executeSqls(bw, tmp, startTime, file);
            pb.stepTo((long)fileLine);
            return;
        }
        catch (FileNotFoundException e) {
            System.out.println("Cannot find " + file.getName() + " because: " + e.getMessage());
            return;
        }
        catch (IOException e) {
            System.out.println("CSV file read exception because: " + e.getMessage());
            return;
        }
        catch (SQLException e) {
            System.out.println("Database connection exception because: " + e.getMessage());
            return;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (errorFlag) {
                    FileUtils.forceDelete((File)errorFile);
                } else {
                    System.out.println("Format of some lines in " + file.getAbsolutePath() + " error, please " + "check " + errorFile.getAbsolutePath() + " for more information");
                }
            }
            catch (SQLException e) {
                System.out.println("Sql statement can not be closed because: " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("Close file error because: " + e.getMessage());
            }
        }
    }

    private static void executeSqls(BufferedWriter bw, List<String> tmp, long startTime, File file) throws IOException {
        try {
            int[] result = statement.executeBatch();
            for (int i = 0; i < result.length; ++i) {
                if (result[i] == -2 || i >= tmp.size()) continue;
                bw.write(tmp.get(i));
                bw.newLine();
                errorFlag = false;
            }
            statement.clearBatch();
            tmp.clear();
        }
        catch (SQLException e) {
            bw.write(e.getMessage());
            bw.newLine();
            errorFlag = false;
            System.out.println("Cannot execute sql because: " + e.getMessage());
        }
    }

    private static boolean readAndGenSqls(BufferedReader br, Map<String, String> timeseriesDataType, Map<String, ArrayList<Integer>> deviceToColumn, List<String> colInfo, List<String> headInfo, BufferedWriter bw, List<String> tmp, ProgressBar pb) throws IOException {
        String line;
        count = 0;
        while ((line = br.readLine()) != null) {
            List<String> sqls;
            try {
                sqls = ImportCsv.createInsertSQL(line, timeseriesDataType, deviceToColumn, colInfo, headInfo);
            }
            catch (Exception e) {
                bw.write(String.format("error input line, maybe it is not complete: %s", line));
                bw.newLine();
                System.out.println("Cannot create sql for " + line + " because: " + e.getMessage());
                errorFlag = false;
                return false;
            }
            boolean success = ImportCsv.addSqlsToBatch(sqls, tmp, bw);
            pb.step();
            if (success) continue;
            return false;
        }
        return true;
    }

    private static boolean addSqlsToBatch(List<String> sqls, List<String> tmp, BufferedWriter bw) throws IOException {
        for (String str : sqls) {
            try {
                ++count;
                statement.addBatch(str);
                tmp.add(str);
                ImportCsv.checkBatchSize(bw, tmp);
            }
            catch (SQLException e) {
                bw.write(e.getMessage());
                bw.newLine();
                errorFlag = false;
                System.out.println("Cannot execute sql because: " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    private static void checkBatchSize(BufferedWriter bw, List<String> tmp) throws SQLException, IOException {
        if (count == 100) {
            int[] result = statement.executeBatch();
            for (int i = 0; i < result.length; ++i) {
                if (result[i] == -2 || i >= tmp.size()) continue;
                bw.write(tmp.get(i));
                bw.newLine();
                errorFlag = false;
            }
            statement.clearBatch();
            count = 0;
            tmp.clear();
        }
    }

    private static boolean queryDatabaseMeta(String[] strHeadInfo, File file, BufferedWriter bw, Map<String, String> timeseriesDataType, List<String> headInfo, Map<String, ArrayList<Integer>> deviceToColumn, List<String> colInfo) throws SQLException, IOException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        for (int i = 1; i < strHeadInfo.length; ++i) {
            ResultSet resultSet = databaseMetaData.getColumns("ts", strHeadInfo[i], null, null);
            if (!resultSet.next()) {
                String errorInfo = String.format("Database cannot find %s in %s, stop import!", strHeadInfo[i], file.getAbsolutePath());
                System.out.println("Database cannot find " + strHeadInfo[i] + " in " + file.getAbsolutePath() + ", " + "stop import!");
                bw.write(errorInfo);
                return false;
            }
            timeseriesDataType.put(strHeadInfo[i], resultSet.getString(2));
            headInfo.add(strHeadInfo[i]);
            String deviceInfo = strHeadInfo[i].substring(0, strHeadInfo[i].lastIndexOf(46));
            if (!deviceToColumn.containsKey(deviceInfo)) {
                deviceToColumn.put(deviceInfo, new ArrayList());
            }
            deviceToColumn.get(deviceInfo).add(i - 1);
            colInfo.add(strHeadInfo[i].substring(strHeadInfo[i].lastIndexOf(46) + 1));
        }
        return true;
    }

    private static List<String> createInsertSQL(String line, Map<String, String> timeseriesToType, Map<String, ArrayList<Integer>> deviceToColumn, List<String> colInfo, List<String> headInfo) {
        String[] data = line.split(",", headInfo.size() + 1);
        ArrayList<String> sqls = new ArrayList<String>();
        for (Map.Entry<String, ArrayList<Integer>> entry : deviceToColumn.entrySet()) {
            String sql = ImportCsv.createOneSql(entry, data, colInfo, timeseriesToType, headInfo);
            if (sql == null) continue;
            sqls.add(sql);
        }
        return sqls;
    }

    private static String createOneSql(Map.Entry<String, ArrayList<Integer>> entry, String[] data, List<String> colInfo, Map<String, String> timeseriesToType, List<String> headInfo) {
        StringBuilder sbd = new StringBuilder();
        ArrayList<Integer> colIndex = entry.getValue();
        sbd.append("insert into ").append(entry.getKey()).append("(timestamp");
        int skipCount = 0;
        for (int j = 0; j < colIndex.size(); ++j) {
            if ("".equals(data[entry.getValue().get(j) + 1])) {
                ++skipCount;
                continue;
            }
            sbd.append(", ").append(colInfo.get(colIndex.get(j)));
        }
        if (skipCount == entry.getValue().size()) {
            return null;
        }
        String timestampsStr = data[0];
        sbd.append(") values(").append(timestampsStr.trim().isEmpty() ? "NO TIMESTAMP" : timestampsStr);
        for (int j = 0; j < colIndex.size(); ++j) {
            if ("".equals(data[entry.getValue().get(j) + 1])) continue;
            if (timeseriesToType.get(headInfo.get(colIndex.get(j))).equals(STRING_DATA_TYPE)) {
                sbd.append(", '").append(data[colIndex.get(j) + 1]).append("'");
                continue;
            }
            sbd.append(",").append(data[colIndex.get(j) + 1]);
        }
        sbd.append(")");
        return sbd.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, SQLException {
        CommandLine commandLine;
        Options options = ImportCsv.createOptions();
        HelpFormatter hf = new HelpFormatter();
        hf.setOptionComparator(null);
        hf.setWidth(92);
        DefaultParser parser = new DefaultParser();
        if (args == null || args.length == 0) {
            System.out.println("Too few params input, please check the following hint.");
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            return;
        }
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println("Parse error: " + e.getMessage());
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            return;
        }
        if (commandLine.hasOption("help")) {
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            return;
        }
        reader.setExpandEvents(false);
        try (ConsoleReader reader = new ConsoleReader();){
            ImportCsv.parseBasicParams(commandLine, reader);
            String filename = commandLine.getOptionValue(FILE_ARGS);
            if (filename == null) {
                hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
                return;
            }
            ImportCsv.parseSpecialParams(commandLine);
            ImportCsv.importCsvFromFile(host, port, username, password, filename, timeZoneID);
        }
    }

    private static void parseSpecialParams(CommandLine commandLine) {
        timeZoneID = commandLine.getOptionValue("tz");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importCsvFromFile(String ip, String port, String username, String password, String filename, String timeZone) throws SQLException {
        String property = System.getProperty(IOTDB_CLI_HOME);
        errorInsertInfo = property == null ? ERROR_INFO_STR : property + File.separatorChar + ERROR_INFO_STR;
        try {
            Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
            connection = (IoTDBConnection)DriverManager.getConnection("jdbc:iotdb://" + ip + ":" + port + "/", username, password);
            timeZoneID = timeZone;
            ImportCsv.setTimeZone();
            File file = new File(filename);
            if (file.isFile()) {
                ImportCsv.importFromSingleFile(file);
            } else if (file.isDirectory()) {
                ImportCsv.importFromDirectory(file);
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("Failed to import data because cannot find IoTDB JDBC Driver, please check whether you have imported driver or not: " + e.getMessage());
        }
        catch (TException e) {
            System.out.println("Encounter an error when connecting to server, because " + e.getMessage());
        }
        catch (SQLException e) {
            System.out.println("Encounter an error when importing data, error is: " + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("Encounter an error, because: " + e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private static void importFromSingleFile(File file) {
        if (file.getName().endsWith(FILE_SUFFIX)) {
            ImportCsv.loadDataFromCSV(file, 1);
        } else {
            System.out.println("File " + file.getName() + "  should ends with '.csv' if you want to import");
        }
    }

    private static void importFromDirectory(File file) {
        int i = 1;
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File subFile : files) {
            if (!subFile.isFile()) continue;
            if (subFile.getName().endsWith(FILE_SUFFIX)) {
                ImportCsv.loadDataFromCSV(subFile, i);
                ++i;
                continue;
            }
            System.out.println("File " + file.getName() + " should ends with '.csv' if you want to import");
        }
    }

    private static int getFileLineCount(File file) throws IOException {
        int line = 0;
        try (LineNumberReader count = new LineNumberReader(new FileReader(file));){
            while (count.skip(Long.MAX_VALUE) > 0L) {
            }
            line = count.getLineNumber() + 1;
        }
        return line;
    }

    static {
        IOTDB_CLI_HOME = "IOTDB_CLI_HOME";
    }
}

