/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cli.client;

import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.cli.exception.ArgsErrorException;
import org.apache.iotdb.cli.tool.ImportCsv;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.iotdb.jdbc.IoTDBDatabaseMetadata;
import org.apache.iotdb.jdbc.IoTDBMetadataResultSet;
import org.apache.iotdb.jdbc.IoTDBQueryResultSet;
import org.apache.iotdb.service.rpc.thrift.ServerProperties;
import org.apache.thrift.TException;

public abstract class AbstractClient {
    protected static final String HOST_ARGS = "h";
    protected static final String HOST_NAME = "host";
    protected static final String HELP_ARGS = "help";
    protected static final String PORT_ARGS = "p";
    protected static final String PORT_NAME = "port";
    protected static final String PASSWORD_ARGS = "pw";
    protected static final String PASSWORD_NAME = "password";
    protected static final String USERNAME_ARGS = "u";
    protected static final String USERNAME_NAME = "username";
    protected static final String ISO8601_ARGS = "disableISO8601";
    protected static final List<String> AGGREGRATE_TIME_LIST = new ArrayList<String>();
    protected static final String MAX_PRINT_ROW_COUNT_ARGS = "maxPRC";
    protected static final String MAX_PRINT_ROW_COUNT_NAME = "maxPrintRowCount";
    protected static final String SET_MAX_DISPLAY_NUM = "set max_display_num";
    protected static final String SET_TIMESTAMP_DISPLAY = "set time_display_type";
    protected static final String SHOW_TIMESTAMP_DISPLAY = "show time_display_type";
    protected static final String SET_TIME_ZONE = "set time_zone";
    protected static final String SHOW_TIMEZONE = "show time_zone";
    protected static final String SET_FETCH_SIZE = "set fetch_size";
    protected static final String SHOW_FETCH_SIZE = "show fetch_size";
    protected static final String HELP = "help";
    protected static final String IOTDB_CLI_PREFIX = "IoTDB";
    protected static final String SCRIPT_HINT = "./start-client.sh(start-client.bat if Windows)";
    protected static final String QUIT_COMMAND = "quit";
    protected static final String EXIT_COMMAND = "exit";
    protected static final String SHOW_METADATA_COMMAND = "show timeseries";
    protected static final int MAX_HELP_CONSOLE_WIDTH = 88;
    protected static final String TIMESTAMP_STR = "Time";
    protected static final int ISO_DATETIME_LEN = 26;
    protected static final String IMPORT_CMD = "import";
    private static final String NEED_NOT_TO_PRINT_TIMESTAMP = "AGGREGATION";
    private static final String DEFAULT_TIME_FORMAT = "default";
    protected static String timeFormat = "default";
    protected static int maxPrintRowCount = 1000;
    protected static int fetchSize = 10000;
    protected static int maxTimeLength = 26;
    protected static int maxValueLength = 15;
    protected static boolean isQuit = false;
    protected static int[] maxValueLengthForShow = new int[]{75, 45, 8, 8};
    protected static String formatTime = "%" + maxTimeLength + "s|";
    protected static String formatValue = "%" + maxValueLength + "s|";
    private static final int DIVIDING_LINE_LENGTH = 40;
    protected static String host = "127.0.0.1";
    protected static String port = "6667";
    protected static String username;
    protected static String password;
    protected static boolean printToConsole;
    protected static Set<String> keywordSet;
    protected static ServerProperties properties;
    private static boolean printHeader;
    private static int displayCnt;
    private static final PrintStream SCREEN_PRINTER;
    private static boolean showException;

    protected static void init() {
        keywordSet.add("-h");
        keywordSet.add("-help");
        keywordSet.add("-p");
        keywordSet.add("-pw");
        keywordSet.add("-u");
        keywordSet.add("-disableISO8601");
        keywordSet.add("-maxPRC");
    }

    public static void output(ResultSet res, boolean printToConsole, ZoneId zoneId) throws SQLException {
        int cnt = 0;
        boolean printTimestamp = true;
        displayCnt = 0;
        printHeader = false;
        ResultSetMetaData resultSetMetaData = res.getMetaData();
        int colCount = resultSetMetaData.getColumnCount();
        boolean isShow = res instanceof IoTDBMetadataResultSet;
        if (!isShow && resultSetMetaData.getColumnTypeName(0) != null) {
            boolean bl = printTimestamp = !res.getMetaData().getColumnTypeName(0).equalsIgnoreCase(NEED_NOT_TO_PRINT_TIMESTAMP);
        }
        if (res instanceof IoTDBQueryResultSet) {
            boolean bl = printTimestamp = printTimestamp && !((IoTDBQueryResultSet)res).isIgnoreTimeStamp();
        }
        while (res.next()) {
            AbstractClient.printRow(printTimestamp, colCount, resultSetMetaData, isShow, res, zoneId);
            if (printToConsole || ++cnt % 10000 != 0) continue;
            AbstractClient.println(cnt);
        }
        if (printToConsole) {
            if (!printHeader) {
                AbstractClient.printBlockLine(printTimestamp, colCount, resultSetMetaData, isShow);
                AbstractClient.printName(printTimestamp, colCount, resultSetMetaData, isShow);
                AbstractClient.printBlockLine(printTimestamp, colCount, resultSetMetaData, isShow);
            } else {
                AbstractClient.printBlockLine(printTimestamp, colCount, resultSetMetaData, isShow);
            }
            if (displayCnt == maxPrintRowCount) {
                AbstractClient.println(String.format("Reach maxPrintRowCount = %s lines", maxPrintRowCount));
            }
        }
        AbstractClient.println(StringUtils.repeat((char)'-', (int)40));
        AbstractClient.printCount(isShow, res, cnt);
    }

    protected static void printCount(boolean isShow, ResultSet res, int cnt) throws SQLException {
        if (isShow) {
            int type = res.getType();
            if (type == IoTDBMetadataResultSet.MetadataType.STORAGE_GROUP.ordinal()) {
                AbstractClient.println("Total storage group number = " + cnt);
            } else if (type == IoTDBMetadataResultSet.MetadataType.TIMESERIES.ordinal()) {
                AbstractClient.println("Total timeseries number = " + cnt);
            }
        } else {
            AbstractClient.println("Total line number = " + cnt);
        }
    }

    protected static void printRow(boolean printTimestamp, int colCount, ResultSetMetaData resultSetMetaData, boolean isShow, ResultSet res, ZoneId zoneId) throws SQLException {
        if (!printToConsole) {
            return;
        }
        AbstractClient.printHeader(printTimestamp, colCount, resultSetMetaData, isShow);
        if (isShow) {
            AbstractClient.printShow(colCount, res);
        } else {
            AbstractClient.printRowData(printTimestamp, res, zoneId, resultSetMetaData, colCount);
        }
    }

    protected static void printHeader(boolean printTimestamp, int colCount, ResultSetMetaData resultSetMetaData, boolean isShow) throws SQLException {
        if (!printHeader) {
            AbstractClient.printBlockLine(printTimestamp, colCount, resultSetMetaData, isShow);
            AbstractClient.printName(printTimestamp, colCount, resultSetMetaData, isShow);
            AbstractClient.printBlockLine(printTimestamp, colCount, resultSetMetaData, isShow);
            printHeader = true;
        }
    }

    protected static void printShow(int colCount, ResultSet res) throws SQLException {
        AbstractClient.print("|");
        for (int i = 1; i <= colCount; ++i) {
            formatValue = "%" + maxValueLengthForShow[i - 1] + "s|";
            AbstractClient.printf(formatValue, String.valueOf(res.getString(i)));
        }
        AbstractClient.println();
    }

    protected static void printRowData(boolean printTimestamp, ResultSet res, ZoneId zoneId, ResultSetMetaData resultSetMetaData, int colCount) throws SQLException {
        if (displayCnt < maxPrintRowCount) {
            AbstractClient.print("|");
            if (printTimestamp) {
                AbstractClient.printf(formatTime, AbstractClient.formatDatetime(res.getLong(TIMESTAMP_STR), zoneId));
            }
            for (int i = 2; i <= colCount; ++i) {
                AbstractClient.printColumnData(resultSetMetaData, res, i, zoneId);
            }
            AbstractClient.println();
            ++displayCnt;
        }
    }

    protected static void printColumnData(ResultSetMetaData resultSetMetaData, ResultSet res, int i, ZoneId zoneId) throws SQLException {
        boolean flag = false;
        for (String timeStr : AGGREGRATE_TIME_LIST) {
            if (!resultSetMetaData.getColumnLabel(i).toUpperCase().contains(timeStr.toUpperCase())) continue;
            flag = true;
            break;
        }
        if (flag) {
            try {
                AbstractClient.printf(formatValue, AbstractClient.formatDatetime(res.getLong(i), zoneId));
            }
            catch (Exception e) {
                AbstractClient.printf(formatValue, "null");
                AbstractClient.handleException(e);
            }
        } else {
            AbstractClient.printf(formatValue, String.valueOf(res.getString(i)));
        }
    }

    protected static Options createOptions() {
        Options options = new Options();
        Option help = new Option("help", false, "Display help information(optional)");
        help.setRequired(false);
        options.addOption(help);
        Option timeFormat = new Option(ISO8601_ARGS, false, "Display timestamp in number(optional)");
        timeFormat.setRequired(false);
        options.addOption(timeFormat);
        Option host = Option.builder((String)HOST_ARGS).argName(HOST_NAME).hasArg().desc("Host Name (optional, default 127.0.0.1)").build();
        options.addOption(host);
        Option port = Option.builder((String)PORT_ARGS).argName(PORT_NAME).hasArg().desc("Port (optional, default 6667)").build();
        options.addOption(port);
        Option username = Option.builder((String)USERNAME_ARGS).argName(USERNAME_NAME).hasArg().desc("User name (required)").required().build();
        options.addOption(username);
        Option password = Option.builder((String)PASSWORD_ARGS).argName(PASSWORD_NAME).hasArg().desc("password (optional)").build();
        options.addOption(password);
        Option maxPrintCount = Option.builder((String)MAX_PRINT_ROW_COUNT_ARGS).argName(MAX_PRINT_ROW_COUNT_NAME).hasArg().desc("Maximum number of rows displayed (optional)").build();
        options.addOption(maxPrintCount);
        return options;
    }

    private static String formatDatetime(long timestamp, ZoneId zoneId) {
        switch (timeFormat) {
            case "long": 
            case "number": {
                return Long.toString(timestamp);
            }
            case "default": 
            case "iso8601": {
                ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId);
                return dateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            }
        }
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId);
        return dateTime.format(DateTimeFormatter.ofPattern(timeFormat));
    }

    protected static String checkRequiredArg(String arg, String name, CommandLine commandLine, boolean isRequired, String defaultValue) throws ArgsErrorException {
        String str = commandLine.getOptionValue(arg);
        if (str == null) {
            if (isRequired) {
                String msg = String.format("%s: Required values for option '%s' not provided", IOTDB_CLI_PREFIX, name);
                AbstractClient.println(msg);
                AbstractClient.println("Use -help for more information");
                throw new ArgsErrorException(msg);
            }
            if (defaultValue == null) {
                String msg = String.format("%s: Required values for option '%s' is null.", IOTDB_CLI_PREFIX, name);
                throw new ArgsErrorException(msg);
            }
            return defaultValue;
        }
        return str;
    }

    protected static void setTimeFormat(String newTimeFormat) {
        switch (newTimeFormat.trim().toLowerCase()) {
            case "long": 
            case "number": {
                maxTimeLength = maxValueLength;
                timeFormat = newTimeFormat.trim().toLowerCase();
                break;
            }
            case "default": 
            case "iso8601": {
                maxTimeLength = 26;
                timeFormat = newTimeFormat.trim().toLowerCase();
                break;
            }
            default: {
                new SimpleDateFormat(newTimeFormat.trim());
                maxTimeLength = TIMESTAMP_STR.length() > newTimeFormat.length() ? TIMESTAMP_STR.length() : newTimeFormat.length();
                timeFormat = newTimeFormat;
            }
        }
        formatTime = "%" + maxTimeLength + "s|";
    }

    private static void setFetchSize(String fetchSizeString) {
        long tmp = Long.parseLong(fetchSizeString.trim());
        fetchSize = tmp > Integer.MAX_VALUE || tmp < 0L ? Integer.MAX_VALUE : Integer.parseInt(fetchSizeString.trim());
    }

    protected static void setMaxDisplayNumber(String maxDisplayNum) {
        long tmp = Long.parseLong(maxDisplayNum.trim());
        maxPrintRowCount = tmp > Integer.MAX_VALUE || tmp < 0L ? Integer.MAX_VALUE : Integer.parseInt(maxDisplayNum.trim());
    }

    protected static void printBlockLine(boolean printTimestamp, int colCount, ResultSetMetaData resultSetMetaData, boolean isShowTs) throws SQLException {
        StringBuilder blockLine = new StringBuilder();
        if (isShowTs) {
            blockLine.append("+");
            for (int i = 1; i <= colCount; ++i) {
                blockLine.append(StringUtils.repeat((char)'-', (int)maxValueLengthForShow[i - 1])).append("+");
            }
        } else {
            int i;
            int tmp = Integer.MIN_VALUE;
            for (i = 1; i <= colCount; ++i) {
                int len = resultSetMetaData.getColumnLabel(i).length();
                tmp = tmp > len ? tmp : len;
            }
            maxValueLength = tmp;
            if (printTimestamp) {
                blockLine.append("+").append(StringUtils.repeat((char)'-', (int)maxTimeLength)).append("+");
            } else {
                blockLine.append("+");
            }
            for (i = 0; i < colCount - 1; ++i) {
                blockLine.append(StringUtils.repeat((char)'-', (int)maxValueLength)).append("+");
            }
        }
        AbstractClient.println(blockLine);
    }

    protected static void printName(boolean printTimestamp, int colCount, ResultSetMetaData resultSetMetaData, boolean isShowTs) throws SQLException {
        AbstractClient.print("|");
        if (isShowTs) {
            for (int i = 1; i <= colCount; ++i) {
                formatValue = "%" + maxValueLengthForShow[i - 1] + "s|";
                AbstractClient.printf(formatValue, resultSetMetaData.getColumnName(i));
            }
        } else {
            formatValue = "%" + maxValueLength + "s|";
            if (printTimestamp) {
                AbstractClient.printf(formatTime, TIMESTAMP_STR);
            }
            for (int i = 2; i <= colCount; ++i) {
                AbstractClient.printf(formatValue, resultSetMetaData.getColumnLabel(i));
            }
        }
        AbstractClient.println();
    }

    protected static String[] removePasswordArgs(String[] args) {
        int index = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-pw")) continue;
            index = i;
            break;
        }
        if (index >= 0 && (index + 1 >= args.length || index + 1 < args.length && keywordSet.contains(args[index + 1]))) {
            return (String[])ArrayUtils.remove((Object[])args, (int)index);
        }
        return args;
    }

    protected static void displayLogo(String version) {
        AbstractClient.println(" _____       _________  ______   ______    \n|_   _|     |  _   _  ||_   _ `.|_   _ \\   \n  | |   .--.|_/ | | \\_|  | | `. \\ | |_) |  \n  | | / .'`\\ \\  | |      | |  | | |  __'.  \n _| |_| \\__. | _| |_    _| |_.' /_| |__) | \n|_____|'.__.' |_____|  |______.'|_______/  version " + version + "\n" + "                                           \n");
    }

    protected static OperationResult handleInputCmd(String cmd, IoTDBConnection connection) {
        String specialCmd = cmd.toLowerCase().trim();
        if (QUIT_COMMAND.equals(specialCmd) || EXIT_COMMAND.equals(specialCmd)) {
            isQuit = true;
            return OperationResult.STOP_OPER;
        }
        if ("help".equals(specialCmd)) {
            AbstractClient.showHelp();
            return OperationResult.CONTINUE_OPER;
        }
        if (SHOW_METADATA_COMMAND.equals(specialCmd)) {
            AbstractClient.showMetaData(connection);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SET_TIMESTAMP_DISPLAY)) {
            AbstractClient.setTimestampDisplay(specialCmd, cmd);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SET_TIME_ZONE)) {
            AbstractClient.setTimeZone(specialCmd, cmd, connection);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SET_FETCH_SIZE)) {
            AbstractClient.setFetchSize(specialCmd, cmd);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SET_MAX_DISPLAY_NUM)) {
            AbstractClient.setMaxDisplaNum(specialCmd, cmd);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SHOW_TIMEZONE)) {
            AbstractClient.showTimeZone(connection);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SHOW_TIMESTAMP_DISPLAY)) {
            AbstractClient.println("Current time format: " + timeFormat);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SHOW_FETCH_SIZE)) {
            AbstractClient.println("Current fetch size: " + fetchSize);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(IMPORT_CMD)) {
            AbstractClient.importCmd(specialCmd, cmd, connection);
            return OperationResult.CONTINUE_OPER;
        }
        AbstractClient.executeQuery(connection, cmd);
        return OperationResult.NO_OPER;
    }

    protected static void showHelp() {
        AbstractClient.println("    <your-sql>\t\t\t execute your sql statment");
        AbstractClient.println(String.format("    %s\t\t show how many timeseries are in iotdb", SHOW_METADATA_COMMAND));
        AbstractClient.println(String.format("    %s=xxx\t eg. long, default, ISO8601, yyyy-MM-dd HH:mm:ss.", SET_TIMESTAMP_DISPLAY));
        AbstractClient.println(String.format("    %s\t show time display type", SHOW_TIMESTAMP_DISPLAY));
        AbstractClient.println(String.format("    %s=xxx\t\t eg. +08:00, Asia/Shanghai.", SET_TIME_ZONE));
        AbstractClient.println(String.format("    %s\t\t show cli time zone", SHOW_TIMEZONE));
        AbstractClient.println(String.format("    %s=xxx\t\t set fetch size when querying data from server.", SET_FETCH_SIZE));
        AbstractClient.println(String.format("    %s\t\t show fetch size", SHOW_FETCH_SIZE));
        AbstractClient.println(String.format("    %s=xxx\t eg. set max lines for cli to ouput, -1 equals to unlimited.", SET_MAX_DISPLAY_NUM));
    }

    protected static void showMetaData(IoTDBConnection connection) {
        try {
            AbstractClient.println(((IoTDBDatabaseMetadata)connection.getMetaData()).getMetadataInJson());
        }
        catch (SQLException e) {
            AbstractClient.println("Failed to show timeseries because: " + e.getMessage());
            AbstractClient.handleException(e);
        }
    }

    protected static void setTimestampDisplay(String specialCmd, String cmd) {
        String[] values = specialCmd.split("=");
        if (values.length != 2) {
            AbstractClient.println(String.format("Time display format error, please input like %s=ISO8601", SET_TIMESTAMP_DISPLAY));
            return;
        }
        try {
            AbstractClient.setTimeFormat(cmd.split("=")[1]);
        }
        catch (Exception e) {
            AbstractClient.println(String.format("time display format error, %s", e.getMessage()));
            AbstractClient.handleException(e);
            return;
        }
        AbstractClient.println("Time display type has set to " + cmd.split("=")[1].trim());
    }

    protected static void setTimeZone(String specialCmd, String cmd, IoTDBConnection connection) {
        String[] values = specialCmd.split("=");
        if (values.length != 2) {
            AbstractClient.println(String.format("Time zone format error, please input like %s=+08:00", SET_TIME_ZONE));
            return;
        }
        try {
            connection.setTimeZone(cmd.split("=")[1].trim());
        }
        catch (Exception e) {
            AbstractClient.println(String.format("Time zone format error: %s", e.getMessage()));
            AbstractClient.handleException(e);
            return;
        }
        AbstractClient.println("Time zone has set to " + values[1].trim());
    }

    protected static void setFetchSize(String specialCmd, String cmd) {
        String[] values = specialCmd.split("=");
        if (values.length != 2) {
            AbstractClient.println(String.format("Fetch size format error, please input like %s=10000", SET_FETCH_SIZE));
            return;
        }
        try {
            AbstractClient.setFetchSize(cmd.split("=")[1]);
        }
        catch (Exception e) {
            AbstractClient.println(String.format("Fetch size format error, %s", e.getMessage()));
            AbstractClient.handleException(e);
            return;
        }
        AbstractClient.println("Fetch size has set to " + values[1].trim());
    }

    protected static void setMaxDisplaNum(String specialCmd, String cmd) {
        String[] values = specialCmd.split("=");
        if (values.length != 2) {
            AbstractClient.println(String.format("Max display number format error, please input like %s = 10000", SET_MAX_DISPLAY_NUM));
            return;
        }
        try {
            AbstractClient.setMaxDisplayNumber(cmd.split("=")[1]);
        }
        catch (Exception e) {
            AbstractClient.println(String.format("Max display number format error, %s", e.getMessage()));
            AbstractClient.handleException(e);
            return;
        }
        AbstractClient.println("Max display number has set to " + values[1].trim());
    }

    protected static void showTimeZone(IoTDBConnection connection) {
        try {
            AbstractClient.println("Current time zone: " + connection.getTimeZone());
        }
        catch (Exception e) {
            AbstractClient.println("Cannot get time zone from server side because: " + e.getMessage());
            AbstractClient.handleException(e);
        }
    }

    protected static void importCmd(String specialCmd, String cmd, IoTDBConnection connection) {
        String[] values = specialCmd.split(" ");
        if (values.length != 2) {
            AbstractClient.println("Please input like: import /User/myfile. Noted that your file path cannot contain any space character)");
            return;
        }
        try {
            AbstractClient.println(cmd.split(" ")[1]);
            ImportCsv.importCsvFromFile(host, port, username, password, cmd.split(" ")[1], connection.getTimeZone());
        }
        catch (SQLException e) {
            AbstractClient.println(String.format("Failed to import from %s because %s", cmd.split(" ")[1], e.getMessage()));
            AbstractClient.handleException(e);
        }
        catch (TException e) {
            AbstractClient.println("Cannot connect to server");
            AbstractClient.handleException((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void executeQuery(IoTDBConnection connection, String cmd) {
        Statement statement = null;
        long startTime = System.currentTimeMillis();
        try {
            ZoneId zoneId = ZoneId.of(connection.getTimeZone());
            statement = connection.createStatement();
            statement.setFetchSize(fetchSize);
            boolean hasResultSet = statement.execute(cmd.trim());
            if (hasResultSet) {
                ResultSet resultSet = statement.getResultSet();
                AbstractClient.output(resultSet, printToConsole, zoneId);
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            AbstractClient.println("Msg: " + e.getMessage());
            AbstractClient.handleException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    AbstractClient.println("Cannot close statement because: " + e.getMessage());
                    AbstractClient.handleException(e);
                }
            }
        }
        long costTime = System.currentTimeMillis() - startTime;
        AbstractClient.println(String.format("It costs %.3fs", (double)costTime / 1000.0));
    }

    protected static void printf(String format, Object ... args) {
        SCREEN_PRINTER.printf(format, args);
    }

    protected static void print(String msg) {
        SCREEN_PRINTER.println(msg);
    }

    protected static void println() {
        SCREEN_PRINTER.println();
    }

    protected static void println(String msg) {
        SCREEN_PRINTER.println(msg);
    }

    protected static void println(Object obj) {
        SCREEN_PRINTER.println(obj);
    }

    protected static void handleException(Exception e) {
        if (showException) {
            e.printStackTrace(SCREEN_PRINTER);
        }
    }

    static {
        printToConsole = true;
        keywordSet = new HashSet<String>();
        properties = null;
        printHeader = false;
        displayCnt = 0;
        SCREEN_PRINTER = new PrintStream(System.out);
        showException = false;
    }

    static enum OperationResult {
        STOP_OPER,
        CONTINUE_OPER,
        NO_OPER;

    }
}

