/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.influxdb;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.influxdb.IoTDBInfluxDBFactory;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Point;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;

public class InfluxDBExample {
    private static InfluxDB influxDB;
    private static final String database = "monitor";
    private static final String measurement = "factory";

    public static void main(String[] args) {
        influxDB = IoTDBInfluxDBFactory.connect((String)"http://127.0.0.1:8086", (String)"root", (String)"root");
        influxDB.createDatabase(database);
        influxDB.setDatabase(database);
        InfluxDBExample.insertData();
        InfluxDBExample.queryData();
        influxDB.close();
    }

    private static void insertData() {
        Point.Builder builder = Point.measurement((String)measurement);
        HashMap<String, String> tags = new HashMap<String, String>();
        HashMap<String, Number> fields = new HashMap<String, Number>();
        tags.put("workshop", "A1");
        tags.put("production", "B1");
        tags.put("cell", "C1");
        fields.put("temperature", 16.9);
        fields.put("pressure", 142);
        builder.tag(tags);
        builder.fields(fields);
        builder.time(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        Point point = builder.build();
        influxDB.write(point);
        builder = Point.measurement((String)measurement);
        tags = new HashMap();
        fields = new HashMap();
        tags.put("workshop", "A1");
        tags.put("production", "B1");
        tags.put("cell", "C2");
        fields.put("temperature", 16.5);
        fields.put("pressure", 108);
        builder.tag(tags);
        builder.fields(fields);
        builder.time(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        point = builder.build();
        influxDB.write(point);
        builder = Point.measurement((String)measurement);
        tags = new HashMap();
        fields = new HashMap();
        tags.put("workshop", "A1");
        tags.put("production", "B2");
        tags.put("cell", "C2");
        fields.put("temperature", 13.0);
        fields.put("pressure", 130);
        builder.tag(tags);
        builder.fields(fields);
        builder.time(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        point = builder.build();
        influxDB.write(point);
    }

    private static void queryData() {
        Query query = new Query("select * from factory where (workshop=\"A1\" and production=\"B1\" and cell =\"C1\" and time>now()-7d)", database);
        QueryResult result = influxDB.query(query);
        System.out.println("query1 result:" + ((QueryResult.Series)((QueryResult.Result)result.getResults().get(0)).getSeries().get(0)).toString());
        query = new Query("select count(temperature),first(temperature),last(temperature),max(temperature),mean(temperature),median(temperature),min(temperature),mode(temperature),spread(temperature),stddev(temperature),sum(temperature) from factory where ((workshop=\"A1\" and production=\"B1\" and cell =\"C1\" ) or temperature< 15 )", database);
        result = influxDB.query(query);
        System.out.println("query2 result:" + ((QueryResult.Series)((QueryResult.Result)result.getResults().get(0)).getSeries().get(0)).toString());
    }
}

