/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.example;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.types.AbstractDataType;

public class StreamingSinkExample {
    public static void main(String[] args) {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().inStreamingMode().build();
        TableEnvironment tableEnv = TableEnvironment.create((EnvironmentSettings)settings);
        Schema dataGenTableSchema = Schema.newBuilder().column("Time_", (AbstractDataType)DataTypes.BIGINT()).column("root.sg.d0.s0", (AbstractDataType)DataTypes.FLOAT()).column("root.sg.d1.s0", (AbstractDataType)DataTypes.FLOAT()).column("root.sg.d1.s1", (AbstractDataType)DataTypes.FLOAT()).build();
        TableDescriptor descriptor = TableDescriptor.forConnector((String)"datagen").schema(dataGenTableSchema).option("rows-per-second", "1").option("fields.Time_.kind", "sequence").option("fields.Time_.start", "1").option("fields.Time_.end", "5").option("fields.root.sg.d0.s0.min", "1").option("fields.root.sg.d0.s0.max", "5").option("fields.root.sg.d1.s0.min", "1").option("fields.root.sg.d1.s0.max", "5").option("fields.root.sg.d1.s1.min", "1").option("fields.root.sg.d1.s1.max", "5").build();
        tableEnv.createTemporaryTable("dataGenTable", descriptor);
        Table dataGenTable = tableEnv.from("dataGenTable");
        TableDescriptor iotdbDescriptor = TableDescriptor.forConnector((String)"IoTDB").schema(dataGenTableSchema).build();
        tableEnv.createTemporaryTable("iotdbSinkTable", iotdbDescriptor);
        dataGenTable.executeInsert("iotdbSinkTable").print();
    }
}

