/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb;

import java.util.ArrayList;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.isession.util.Version;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.session.Session;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.common.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntaxConventionRelatedExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyntaxConventionRelatedExample.class);
    private static Session session;
    private static final String LOCAL_HOST = "127.0.0.1";
    private static final String ROOT_SG1_KEYWORD_EXAMPLE = "root.sg1.select";
    private static final String ROOT_SG1_DIGITS_EXAMPLE = "root.sg1.`111`";
    private static final String ROOT_SG1_SPECIAL_CHARACTER_EXAMPLE = "root.sg1.`a\"b'c```";
    private static final String ROOT_SG1_NORMAL_NODE_EXAMPLE = "root.sg1.a";

    public static void main(String[] args) throws IoTDBConnectionException, StatementExecutionException {
        block10: {
            session = new Session.Builder().host(LOCAL_HOST).port(6667).username("root").password("root").version(Version.V_1_0).build();
            session.open(false);
            session.setFetchSize(10000);
            try {
                session.setStorageGroup("root.sg1");
            }
            catch (StatementExecutionException e) {
                if (e.getStatusCode() == TSStatusCode.PATH_ALREADY_EXIST.getStatusCode()) break block10;
                throw e;
            }
        }
        SyntaxConventionRelatedExample.createTimeSeries();
        SessionDataSet dataSet = session.executeQueryStatement("show timeseries root.sg1.*");
        ArrayList<String> paths = new ArrayList<String>();
        while (dataSet.hasNext()) {
            paths.add(((Field)dataSet.next().getFields().get(0)).toString());
        }
        long startTime = 1L;
        long endTime = 100L;
        long timeOut = 60000L;
        try (SessionDataSet dataSet1 = session.executeRawDataQuery(paths, startTime, endTime, timeOut);){
            LOGGER.info("columnNames = {}", (Object)dataSet1.getColumnNames());
            dataSet1.setFetchSize(1024);
            while (dataSet1.hasNext()) {
                LOGGER.info("data = {}", (Object)dataSet1.next());
            }
        }
    }

    private static void createTimeSeries() throws IoTDBConnectionException, StatementExecutionException {
        if (!session.checkTimeseriesExists(ROOT_SG1_KEYWORD_EXAMPLE)) {
            session.createTimeseries(ROOT_SG1_KEYWORD_EXAMPLE, TSDataType.FLOAT, TSEncoding.RLE, CompressionType.SNAPPY);
        }
        if (!session.checkTimeseriesExists(ROOT_SG1_DIGITS_EXAMPLE)) {
            session.createTimeseries(ROOT_SG1_DIGITS_EXAMPLE, TSDataType.FLOAT, TSEncoding.RLE, CompressionType.SNAPPY);
        }
        if (!session.checkTimeseriesExists(ROOT_SG1_SPECIAL_CHARACTER_EXAMPLE)) {
            session.createTimeseries(ROOT_SG1_SPECIAL_CHARACTER_EXAMPLE, TSDataType.FLOAT, TSEncoding.RLE, CompressionType.SNAPPY);
        }
        if (!session.checkTimeseriesExists(ROOT_SG1_NORMAL_NODE_EXAMPLE)) {
            session.createTimeseries(ROOT_SG1_NORMAL_NODE_EXAMPLE, TSDataType.FLOAT, TSEncoding.RLE, CompressionType.SNAPPY);
        }
    }
}

