/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.isession.pool.SessionDataSetWrapper;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.tsfile.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionPoolExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionPoolExample.class);
    private static SessionPool sessionPool;
    private static ExecutorService service;

    private static void constructCustomSessionPool() {
        sessionPool = new SessionPool.Builder().host("127.0.0.1").port(6667).user("root").password("root").maxSize(3).build();
    }

    private static void constructRedirectSessionPool() {
        ArrayList<String> nodeUrls = new ArrayList<String>();
        nodeUrls.add("127.0.0.1:6667");
        nodeUrls.add("127.0.0.1:6668");
        sessionPool = new SessionPool.Builder().nodeUrls(nodeUrls).user("root").password("root").maxSize(3).build();
    }

    public static void main(String[] args) throws StatementExecutionException, IoTDBConnectionException, InterruptedException {
        SessionPoolExample.constructRedirectSessionPool();
        service = Executors.newFixedThreadPool(10);
        SessionPoolExample.insertRecord();
        SessionPoolExample.queryByRowRecord();
        Thread.sleep(1000L);
        SessionPoolExample.queryByIterator();
        sessionPool.close();
        service.shutdown();
    }

    private static void insertRecord() throws StatementExecutionException, IoTDBConnectionException {
        String deviceId = "root.sg1.d1";
        ArrayList<String> measurements = new ArrayList<String>();
        ArrayList<TSDataType> types = new ArrayList<TSDataType>();
        measurements.add("s1");
        measurements.add("s2");
        measurements.add("s3");
        types.add(TSDataType.INT64);
        types.add(TSDataType.INT64);
        types.add(TSDataType.INT64);
        for (long time = 0L; time < 10L; ++time) {
            ArrayList<Long> values = new ArrayList<Long>();
            values.add(1L);
            values.add(2L);
            values.add(3L);
            sessionPool.insertRecord(deviceId, time, measurements, types, values);
        }
    }

    private static void queryByRowRecord() {
        for (int i = 0; i < 1; ++i) {
            service.submit(() -> {
                SessionDataSetWrapper wrapper = null;
                try {
                    wrapper = sessionPool.executeQueryStatement("select * from root.sg1.d1");
                    System.out.println(wrapper.getColumnNames());
                    System.out.println(wrapper.getColumnTypes());
                    while (wrapper.hasNext()) {
                        System.out.println(wrapper.next());
                    }
                }
                catch (IoTDBConnectionException | StatementExecutionException e) {
                    LOGGER.error("Query by row record error", e);
                }
                finally {
                    sessionPool.closeResultSet(wrapper);
                }
            });
        }
    }

    private static void queryByIterator() {
        for (int i = 0; i < 1; ++i) {
            service.submit(() -> {
                SessionDataSetWrapper wrapper = null;
                try {
                    wrapper = sessionPool.executeQueryStatement("select * from root.sg1.d1");
                    SessionDataSet.DataIterator dataIterator = wrapper.iterator();
                    System.out.println(wrapper.getColumnNames());
                    System.out.println(wrapper.getColumnTypes());
                    while (dataIterator.next()) {
                        StringBuilder builder = new StringBuilder();
                        for (String columnName : wrapper.getColumnNames()) {
                            builder.append(dataIterator.getString(columnName) + " ");
                        }
                        System.out.println(builder);
                    }
                }
                catch (IoTDBConnectionException | StatementExecutionException e) {
                    LOGGER.error("Query by Iterator error", e);
                }
                finally {
                    sessionPool.closeResultSet(wrapper);
                }
            });
        }
    }
}

