/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.service;

import java.util.List;
import javax.transaction.Transactional;
import org.apache.inlong.tubemq.manager.controller.TubeMQResult;
import org.apache.inlong.tubemq.manager.entry.RegionEntry;
import org.apache.inlong.tubemq.manager.repository.BrokerRepository;
import org.apache.inlong.tubemq.manager.repository.MasterRepository;
import org.apache.inlong.tubemq.manager.repository.RegionRepository;
import org.apache.inlong.tubemq.manager.service.interfaces.BrokerService;
import org.apache.inlong.tubemq.manager.service.interfaces.RegionService;
import org.apache.inlong.tubemq.manager.utils.ValidateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Component;

@Component
public class RegionServiceImpl
implements RegionService {
    private static final Logger log = LoggerFactory.getLogger(RegionServiceImpl.class);
    public static final String DUPLICATE_ENTRY = "duplicate entry";
    @Autowired
    RegionRepository regionRepository;
    @Autowired
    BrokerRepository brokerRepository;
    @Autowired
    MasterRepository masterRepository;
    @Autowired
    BrokerService brokerService;

    @Override
    public TubeMQResult createNewRegion(RegionEntry regionEntry, List<Long> brokerIdList) {
        try {
            Long clusterId = regionEntry.getClusterId();
            if (!this.brokerService.checkIfBrokersAllExsit(brokerIdList, clusterId)) {
                return TubeMQResult.errorResult("resource not exsit");
            }
            if (this.existBrokerIdAlreadyInRegion(clusterId, brokerIdList, null)) {
                return TubeMQResult.errorResult("resource already used");
            }
            this.regionRepository.save(regionEntry);
            this.brokerService.updateBrokersRegion(brokerIdList, regionEntry.getRegionId(), clusterId);
        }
        catch (DataIntegrityViolationException e) {
            log.error("duplicate entry, newRegionDO:{}.", (Object)regionEntry, (Object)e);
            return TubeMQResult.errorResult(DUPLICATE_ENTRY);
        }
        catch (Exception e) {
            log.error("create region failed, newRegionDO:{}.", (Object)regionEntry, (Object)e);
            return TubeMQResult.errorResult("mysql error");
        }
        return TubeMQResult.successResult();
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public TubeMQResult deleteRegion(long regionId, long clusterId) {
        try {
            this.regionRepository.deleteRegion(regionId, clusterId);
            this.brokerService.resetBrokerRegions(regionId, clusterId);
        }
        catch (Exception e) {
            log.error("delete region failed, regionId:{}.", (Object)regionId, (Object)e);
            throw new RuntimeException("mysql error");
        }
        return TubeMQResult.successResult();
    }

    private RegionEntry getRegionEntry(long clusterId, long regionId) {
        List<RegionEntry> regionEntries = this.regionRepository.findRegionEntriesByClusterIdEqualsAndRegionIdEquals(clusterId, regionId);
        if (regionEntries.isEmpty()) {
            return null;
        }
        if (regionEntries.size() > 1) {
            throw new RuntimeException(DUPLICATE_ENTRY);
        }
        return regionEntries.get(0);
    }

    @Override
    public TubeMQResult updateRegion(RegionEntry newRegionEntry, List<Long> brokerIdList, long clusterId) {
        if (ValidateUtils.isNull(newRegionEntry) || ValidateUtils.isNull(newRegionEntry.getRegionId())) {
            return TubeMQResult.errorResult("param illegal");
        }
        try {
            RegionEntry oldRegionDO = this.getRegionEntry(clusterId, newRegionEntry.getRegionId());
            if (ValidateUtils.isNull(oldRegionDO)) {
                return TubeMQResult.errorResult("resource not exsit");
            }
            newRegionEntry.setId(oldRegionDO.getId());
            List<Long> oldBrokerList = this.brokerService.getBrokerIdListInRegion(oldRegionDO.getRegionId(), clusterId);
            if (oldBrokerList.equals(brokerIdList)) {
                this.regionRepository.save(newRegionEntry);
                return TubeMQResult.successResult();
            }
            if (this.existBrokerIdAlreadyInRegion(newRegionEntry.getClusterId(), brokerIdList, newRegionEntry.getRegionId())) {
                return TubeMQResult.errorResult("resource already used");
            }
            this.handleUpdateRepo(newRegionEntry, brokerIdList, clusterId);
        }
        catch (Exception e) {
            log.error("update region failed, newRegionDO:{}", (Object)newRegionEntry, (Object)e);
            return TubeMQResult.errorResult("mysql error");
        }
        return TubeMQResult.successResult();
    }

    @Transactional(rollbackOn={Exception.class})
    public void handleUpdateRepo(RegionEntry newRegionEntry, List<Long> brokerIdList, long clusterId) {
        this.regionRepository.save(newRegionEntry);
        this.brokerService.resetBrokerRegions(newRegionEntry.getRegionId(), clusterId);
        this.brokerService.updateBrokersRegion(brokerIdList, newRegionEntry.getRegionId(), newRegionEntry.getClusterId());
    }

    @Override
    public List<RegionEntry> queryRegion(Long regionId, Long clusterId) {
        if (ValidateUtils.isNull(regionId)) {
            return this.regionRepository.findRegionEntriesByClusterIdEquals(clusterId);
        }
        return this.regionRepository.findRegionEntriesByClusterIdEqualsAndRegionIdEquals(clusterId, regionId);
    }

    private boolean existBrokerIdAlreadyInRegion(Long clusterId, List<Long> newBrokerIdList, Long regionId) {
        if (ValidateUtils.isNull(clusterId) || ValidateUtils.isEmptyList(newBrokerIdList)) {
            return true;
        }
        List<RegionEntry> regionEntries = this.regionRepository.findRegionEntriesByClusterIdEquals(clusterId);
        if (ValidateUtils.isEmptyList(regionEntries)) {
            return false;
        }
        for (RegionEntry regionEntry : regionEntries) {
            List<Long> regionBrokerIdList;
            if (regionEntry.getRegionId().equals(regionId) || ValidateUtils.isEmptyList(regionBrokerIdList = this.brokerService.getBrokerIdListInRegion(regionEntry.getRegionId(), clusterId)) || !regionBrokerIdList.stream().anyMatch(newBrokerIdList::contains)) continue;
            return true;
        }
        return false;
    }
}

