/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.service;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.inlong.tubemq.manager.controller.TubeMQResult;
import org.apache.inlong.tubemq.manager.controller.node.dto.MasterDto;
import org.apache.inlong.tubemq.manager.controller.node.request.AddBrokersReq;
import org.apache.inlong.tubemq.manager.controller.node.request.AddTopicReq;
import org.apache.inlong.tubemq.manager.controller.node.request.BatchAddTopicReq;
import org.apache.inlong.tubemq.manager.controller.node.request.CloneBrokersReq;
import org.apache.inlong.tubemq.manager.controller.node.request.CloneTopicReq;
import org.apache.inlong.tubemq.manager.controller.node.request.QueryBrokerCfgReq;
import org.apache.inlong.tubemq.manager.entry.MasterEntry;
import org.apache.inlong.tubemq.manager.repository.MasterRepository;
import org.apache.inlong.tubemq.manager.service.TubeConst;
import org.apache.inlong.tubemq.manager.service.interfaces.MasterService;
import org.apache.inlong.tubemq.manager.service.interfaces.NodeService;
import org.apache.inlong.tubemq.manager.service.interfaces.TopicService;
import org.apache.inlong.tubemq.manager.service.tube.AddBrokerResult;
import org.apache.inlong.tubemq.manager.service.tube.AddTopicsResult;
import org.apache.inlong.tubemq.manager.service.tube.BrokerConf;
import org.apache.inlong.tubemq.manager.service.tube.BrokerStatusInfo;
import org.apache.inlong.tubemq.manager.service.tube.IpIdRelation;
import org.apache.inlong.tubemq.manager.service.tube.TubeHttpBrokerInfoList;
import org.apache.inlong.tubemq.manager.service.tube.TubeHttpResponse;
import org.apache.inlong.tubemq.manager.service.tube.TubeHttpTopicInfoList;
import org.apache.inlong.tubemq.manager.utils.ConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class NodeServiceImpl
implements NodeService {
    private static final Logger log = LoggerFactory.getLogger(NodeServiceImpl.class);
    private final CloseableHttpClient httpclient = HttpClients.createDefault();
    private final Gson gson = new Gson();
    @Value(value="${manager.max.configurable.broker.size:50}")
    private int maxConfigurableBrokerSize;
    @Autowired
    private MasterRepository masterRepository;
    @Autowired
    private TopicService topicService;
    @Autowired
    private MasterService masterService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TubeHttpBrokerInfoList requestBrokerStatus(MasterEntry masterEntry) {
        String url = "http://" + masterEntry.getIp() + ":" + masterEntry.getWebPort() + "/webapi.htm?type=op_query&method=admin_query_broker_run_status";
        HttpGet httpget = new HttpGet(url);
        try (CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpget);){
            TubeHttpBrokerInfoList brokerInfoList = (TubeHttpBrokerInfoList)this.gson.fromJson((Reader)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8), TubeHttpBrokerInfoList.class);
            if (brokerInfoList.getCode() == TubeConst.SUCCESS_CODE.intValue()) {
                brokerInfoList.divideBrokerListByState();
                TubeHttpBrokerInfoList tubeHttpBrokerInfoList = brokerInfoList;
                return tubeHttpBrokerInfoList;
            }
            log.error("query brokerInfo list fail with info returned by master {}", (Object)brokerInfoList.getErrMsg());
            return null;
        }
        catch (Exception ex) {
            log.error("exception caught while requesting broker status, master may not be online", (Throwable)ex);
        }
        return null;
    }

    @Override
    public TubeMQResult cloneBrokersWithTopic(CloneBrokersReq req) throws Exception {
        MasterEntry masterEntry;
        QueryBrokerCfgReq queryReq;
        BrokerStatusInfo brokerStatusInfo;
        BrokerConf sourceBrokerConf;
        int clusterId = req.getClusterId();
        AddBrokersReq addBrokersReq = this.getBatchAddBrokersReq(req, clusterId, sourceBrokerConf = (brokerStatusInfo = this.getBrokerStatusInfo(queryReq = QueryBrokerCfgReq.getReq(req.getSourceBrokerId()), masterEntry = this.masterRepository.findMasterEntryByClusterIdEquals(clusterId))).getData().get(0));
        AddBrokerResult addBrokerResult = this.addBrokersToClusterWithId(addBrokersReq, masterEntry);
        if (addBrokerResult.getErrCode() != TubeConst.SUCCESS_CODE.intValue()) {
            return TubeMQResult.errorResult(addBrokerResult.getErrMsg());
        }
        List<Integer> brokerIds = this.getBrokerIds(addBrokerResult);
        List<AddTopicReq> addTopicReqs = req.getAddTopicReqs();
        return this.addTopicsToBrokers(masterEntry, brokerIds, addTopicReqs);
    }

    @Override
    public TubeMQResult addTopicsToBrokers(MasterEntry masterEntry, List<Integer> brokerIds, List<AddTopicReq> addTopicReqs) {
        TubeMQResult tubeResult = new TubeMQResult();
        AddTopicsResult addTopicsResult = new AddTopicsResult();
        if (CollectionUtils.isEmpty(addTopicReqs)) {
            return tubeResult;
        }
        addTopicReqs.forEach(addTopicReq -> {
            try {
                String brokerStr = StringUtils.join((Iterable)brokerIds, (String)",");
                addTopicReq.setBrokerId(brokerStr);
                TubeMQResult result = this.addTopicToBrokers((AddTopicReq)addTopicReq, masterEntry);
                if (result.getErrCode() == TubeConst.SUCCESS_CODE.intValue()) {
                    addTopicsResult.getSuccessTopics().add(addTopicReq.getTopicName());
                } else {
                    addTopicsResult.getFailTopics().add(addTopicReq.getTopicName());
                }
            }
            catch (Exception e) {
                log.error("add topic to brokers fail with exception", (Throwable)e);
                addTopicsResult.getFailTopics().add(addTopicReq.getTopicName());
            }
        });
        tubeResult.setData(addTopicsResult);
        return tubeResult;
    }

    private List<Integer> getBrokerIds(AddBrokerResult addBrokerResult) {
        List<IpIdRelation> ipids = addBrokerResult.getData();
        ArrayList brokerIds = Lists.newArrayList();
        for (IpIdRelation ipid : ipids) {
            brokerIds.add(ipid.getId());
        }
        return brokerIds;
    }

    private AddBrokersReq getBatchAddBrokersReq(CloneBrokersReq req, int clusterId, BrokerConf sourceBrokerConf) {
        AddBrokersReq addBrokersReq = AddBrokersReq.getAddBrokerReq(req.getConfModAuthToken(), clusterId);
        ArrayList brokerConfs = Lists.newArrayList();
        req.getTargetIps().forEach(ip -> {
            BrokerConf brokerConf = new BrokerConf(sourceBrokerConf);
            brokerConf.setBrokerIp((String)ip);
            brokerConf.setBrokerId(0);
            brokerConfs.add(brokerConf);
        });
        addBrokersReq.setBrokerJsonSet(brokerConfs);
        return addBrokersReq;
    }

    private BrokerStatusInfo getBrokerStatusInfo(QueryBrokerCfgReq queryReq, MasterEntry masterEntry) throws Exception {
        String url = "http://" + masterEntry.getIp() + ":" + masterEntry.getWebPort() + "/" + "webapi.htm" + "?" + ConvertUtils.convertReqToQueryStr(queryReq);
        BrokerStatusInfo brokerStatusInfo = (BrokerStatusInfo)this.gson.fromJson(this.masterService.queryMaster(url), BrokerStatusInfo.class);
        return brokerStatusInfo;
    }

    @Override
    public TubeMQResult addTopicToBrokers(AddTopicReq req, MasterEntry masterEntry) throws Exception {
        String url = "http://" + masterEntry.getIp() + ":" + masterEntry.getWebPort() + "/" + "webapi.htm" + "?" + ConvertUtils.convertReqToQueryStr(req);
        return this.masterService.requestMaster(url);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean configBrokersForTopics(MasterEntry masterEntry, Set<String> topics, List<Integer> brokerList, int maxBrokers) {
        if (maxBrokers == 0) {
            return false;
        }
        List<Integer> finalBrokerList = brokerList.subList(0, maxBrokers);
        String brokerStr = StringUtils.join(finalBrokerList, (String)",");
        String topicStr = StringUtils.join(topics, (String)",");
        String url = "http://" + masterEntry.getIp() + ":" + masterEntry.getWebPort() + "/webapi.htm?type=op_modify&method=admin_add_new_topic_record" + "&topicName=" + topicStr + "&brokerId=" + brokerStr + "&confModAuthToken=" + masterEntry.getToken() + "&createUser=" + "tubeAdmin";
        HttpGet httpget = new HttpGet(url);
        log.info("config topics {} to brokers ids {}, masterEntry is : {}", new Object[]{topics, finalBrokerList, masterEntry.getIp()});
        try (CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpget);){
            TubeHttpResponse result = (TubeHttpResponse)this.gson.fromJson((Reader)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8), TubeHttpResponse.class);
            if (result.getErrCode() != TubeConst.SUCCESS_CODE.intValue()) {
                log.error("config topics {} to brokers ids {} fail : master return with status {}", new Object[]{topics, finalBrokerList, result.getErrMsg()});
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            log.error("exception caught while requesting broker status", (Throwable)ex);
            return false;
        }
    }

    @Override
    public void handleReloadBroker(MasterEntry masterEntry, List<Integer> needReloadList) {
        if (needReloadList.isEmpty()) {
            return;
        }
        int begin = 0;
        int end = 0;
        do {
            end = Math.min(this.maxConfigurableBrokerSize + begin, needReloadList.size());
            List<Integer> brokerIdList = needReloadList.subList(begin, end);
            String brokerStr = StringUtils.join(brokerIdList, (String)",");
            String url = "http://" + masterEntry.getIp() + ":" + masterEntry.getWebPort() + "/webapi.htm?type=op_modify&method=admin_reload_broker_configure" + "&brokerId=" + brokerStr + "&confModAuthToken=" + masterEntry.getToken() + "&modifyUser=" + "tubeadmin";
            HttpGet httpget = new HttpGet(url);
            try (CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpget);){
                TubeHttpResponse result = (TubeHttpResponse)this.gson.fromJson((Reader)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8), TubeHttpResponse.class);
                if (result.getErrCode() != TubeConst.SUCCESS_CODE.intValue()) {
                    log.info("reload tube broker : {} to master {}, fail with msg: {}", new Object[]{brokerStr, masterEntry.getIp(), result.getErrMsg()});
                }
            }
            catch (Exception ex) {
                log.error("exception caught while requesting brokers {} status, master is {}", new Object[]{brokerStr, masterEntry.getIp(), ex});
            }
            begin = end;
        } while (end < needReloadList.size());
    }

    @Override
    public void close() throws IOException {
        this.httpclient.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AddBrokerResult addBrokersToClusterWithId(AddBrokersReq req, MasterEntry masterEntry) throws Exception {
        String url = "http://" + masterEntry.getIp() + ":" + masterEntry.getWebPort() + "/" + "webapi.htm" + "?" + ConvertUtils.convertReqToQueryStr(req);
        HttpGet httpget = new HttpGet(url);
        try (CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpget);){
            AddBrokerResult addBrokerResult = (AddBrokerResult)this.gson.fromJson((Reader)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8), AddBrokerResult.class);
            return addBrokerResult;
        }
        catch (Exception ex) {
            log.error("exception caught while requesting broker status", (Throwable)ex);
            return null;
        }
    }

    @Override
    public TubeMQResult cloneTopicToBrokers(CloneTopicReq req) throws Exception {
        TubeHttpBrokerInfoList brokerInfoList;
        MasterEntry master = this.masterService.getMasterNode(req);
        if (master == null) {
            return TubeMQResult.errorResult("no such cluster");
        }
        TubeHttpTopicInfoList topicInfoList = this.topicService.requestTopicConfigInfo(master, req.getSourceTopicName());
        if (topicInfoList == null) {
            return TubeMQResult.errorResult("no such topic");
        }
        List<Integer> brokerId = req.getBrokerId();
        if (CollectionUtils.isEmpty(brokerId) && (brokerInfoList = this.requestBrokerStatus(master)) != null) {
            brokerId = brokerInfoList.getConfigurableBrokerIdList();
        }
        AddTopicReq addTopicReq = topicInfoList.getAddTopicReq(brokerId, req.getTargetTopicName(), req.getConfModAuthToken());
        return this.addTopicToBrokers(addTopicReq, master);
    }

    @Override
    public TubeMQResult batchAddTopic(BatchAddTopicReq req) {
        MasterEntry masterEntry = this.masterService.getMasterNode(req);
        if (masterEntry == null) {
            return TubeMQResult.errorResult("no such cluster");
        }
        return this.addTopicsToBrokers(masterEntry, req.getBrokerIds(), req.getAddTopicReqs());
    }

    @Override
    public void addNode(MasterEntry masterEntry) {
        try {
            this.masterRepository.saveAndFlush(masterEntry);
        }
        catch (Exception e) {
            log.error("save masterEntry {} to db fail with ex ", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public TubeMQResult modifyMasterNode(MasterDto masterDto) {
        try {
            MasterEntry masterEntry = this.masterRepository.findMasterEntryByClusterIdEquals(masterDto.getClusterId());
            masterEntry.setIp(masterDto.getIp());
            masterEntry.setStandby(masterDto.isStandBy());
            masterEntry.setToken(masterDto.getToken());
            masterEntry.setWebPort(masterDto.getWebPort());
            masterEntry.setIp(masterDto.getIp());
            this.masterRepository.save(masterEntry);
        }
        catch (Exception e) {
            log.error("modify master node error with ex", (Throwable)e);
            return TubeMQResult.errorResult(e.getMessage());
        }
        return TubeMQResult.successResult();
    }
}

