/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.service;

import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.tubemq.manager.controller.TubeMQResult;
import org.apache.inlong.tubemq.manager.controller.node.request.BaseReq;
import org.apache.inlong.tubemq.manager.entry.MasterEntry;
import org.apache.inlong.tubemq.manager.repository.MasterRepository;
import org.apache.inlong.tubemq.manager.service.TubeConst;
import org.apache.inlong.tubemq.manager.service.interfaces.MasterService;
import org.apache.inlong.tubemq.manager.service.tube.TubeHttpResponse;
import org.apache.inlong.tubemq.manager.utils.ConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MasterServiceImpl
implements MasterService {
    private static final Logger log = LoggerFactory.getLogger(MasterServiceImpl.class);
    private static CloseableHttpClient httpclient = HttpClients.createDefault();
    private static Gson gson = new Gson();
    @Autowired
    MasterRepository masterRepository;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TubeMQResult requestMaster(String url) {
        log.info("start to request {}", (Object)url);
        HttpGet httpGet = new HttpGet(url);
        TubeMQResult defaultResult = new TubeMQResult();
        try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);){
            TubeHttpResponse tubeResponse = (TubeHttpResponse)gson.fromJson((Reader)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8), TubeHttpResponse.class);
            if (tubeResponse.getCode() == TubeConst.SUCCESS_CODE.intValue() && tubeResponse.getErrCode() == TubeConst.SUCCESS_CODE.intValue()) {
                TubeMQResult tubeMQResult = defaultResult;
                return tubeMQResult;
            }
            defaultResult = TubeMQResult.errorResult(tubeResponse.getErrMsg());
            return defaultResult;
        }
        catch (Exception ex) {
            log.error("exception caught while requesting broker status", (Throwable)ex);
            return TubeMQResult.errorResult(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String queryMaster(String url) {
        log.info("start to request {}", (Object)url);
        HttpGet httpGet = new HttpGet(url);
        TubeMQResult defaultResult = new TubeMQResult();
        try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);){
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        catch (Exception ex) {
            log.error("exception caught while requesting broker status", (Throwable)ex);
            defaultResult.setErrCode(-1);
            defaultResult.setResult(false);
            defaultResult.setErrMsg(ex.getMessage());
            return gson.toJson((Object)defaultResult);
        }
    }

    @Override
    public TubeMQResult baseRequestMaster(BaseReq req) {
        if (req.getClusterId() == null) {
            return TubeMQResult.errorResult("please input clusterId");
        }
        MasterEntry masterEntry = this.masterRepository.findMasterEntryByClusterIdEquals(req.getClusterId().intValue());
        if (masterEntry == null) {
            return TubeMQResult.errorResult("no such cluster");
        }
        String url = "http://" + masterEntry.getIp() + ":" + masterEntry.getWebPort() + "/" + "webapi.htm" + "?" + "&confModAuthToken=" + masterEntry.getToken() + "&" + ConvertUtils.convertReqToQueryStr(req);
        return this.requestMaster(url);
    }

    @Override
    public MasterEntry getMasterNode(BaseReq req) {
        if (req.getClusterId() == null) {
            return null;
        }
        return this.masterRepository.findMasterEntryByClusterIdEquals(req.getClusterId().intValue());
    }

    @Override
    public MasterEntry getMasterNode(Long clusterId) {
        if (clusterId == null) {
            return null;
        }
        MasterEntry master = this.masterRepository.findMasterEntryByClusterIdEquals(clusterId);
        if (master == null) {
            throw new RuntimeException("cluster id " + clusterId + "no master node, please check");
        }
        return master;
    }

    @Override
    public String getQueryUrl(Map<String, String> queryBody) throws Exception {
        int clusterId = Integer.parseInt(queryBody.get("clusterId"));
        queryBody.remove("clusterId");
        MasterEntry masterEntry = this.masterRepository.findMasterEntryByClusterIdEquals(clusterId);
        return "http://" + masterEntry.getIp() + ":" + masterEntry.getWebPort() + "/" + "webapi.htm" + "?" + ConvertUtils.covertMapToQueryString(queryBody);
    }

    @Override
    public TubeMQResult checkMasterNodeStatus(String masterIp, Integer masterWebPort) {
        String url = "http://" + masterIp + ":" + masterWebPort + "/webapi.htm?type=op_query&method=admin_query_broker_run_status";
        return this.requestMaster(url);
    }
}

