/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.controller.topic;

import com.google.gson.Gson;
import java.util.Map;
import org.apache.inlong.tubemq.manager.controller.TubeMQResult;
import org.apache.inlong.tubemq.manager.controller.node.request.BaseReq;
import org.apache.inlong.tubemq.manager.controller.node.request.BatchAddTopicReq;
import org.apache.inlong.tubemq.manager.controller.node.request.CloneTopicReq;
import org.apache.inlong.tubemq.manager.controller.topic.request.DeleteTopicReq;
import org.apache.inlong.tubemq.manager.controller.topic.request.ModifyTopicReq;
import org.apache.inlong.tubemq.manager.controller.topic.request.QueryCanWriteReq;
import org.apache.inlong.tubemq.manager.controller.topic.request.SetAuthControlReq;
import org.apache.inlong.tubemq.manager.service.interfaces.MasterService;
import org.apache.inlong.tubemq.manager.service.interfaces.NodeService;
import org.apache.inlong.tubemq.manager.service.interfaces.TopicService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/v1/topic"})
public class TopicWebController {
    private static final Logger log = LoggerFactory.getLogger(TopicWebController.class);
    @Autowired
    private NodeService nodeService;
    private Gson gson = new Gson();
    @Autowired
    private MasterService masterService;
    @Autowired
    private TopicService topicService;

    @RequestMapping(value={""})
    @ResponseBody
    public TubeMQResult topicMethodProxy(@RequestParam String method, @RequestBody String req) throws Exception {
        switch (method) {
            case "add": {
                return this.nodeService.batchAddTopic((BatchAddTopicReq)this.gson.fromJson(req, BatchAddTopicReq.class));
            }
            case "clone": {
                return this.nodeService.cloneTopicToBrokers((CloneTopicReq)this.gson.fromJson(req, CloneTopicReq.class));
            }
            case "authControl": {
                return this.setAuthControl((SetAuthControlReq)this.gson.fromJson(req, SetAuthControlReq.class));
            }
            case "modify": {
                return this.masterService.baseRequestMaster((BaseReq)this.gson.fromJson(req, ModifyTopicReq.class));
            }
            case "delete": 
            case "remove": {
                return this.masterService.baseRequestMaster((BaseReq)this.gson.fromJson(req, DeleteTopicReq.class));
            }
            case "queryCanWrite": {
                return this.queryCanWrite((QueryCanWriteReq)this.gson.fromJson(req, QueryCanWriteReq.class));
            }
        }
        return TubeMQResult.errorResult("no such method");
    }

    private TubeMQResult setAuthControl(SetAuthControlReq req) {
        req.setMethod("admin_set_topic_authorize_control");
        req.setType("op_modify");
        req.setCreateUser("tubeAdmin");
        return this.masterService.baseRequestMaster(req);
    }

    private TubeMQResult queryCanWrite(QueryCanWriteReq req) {
        if (!req.legal()) {
            return TubeMQResult.errorResult("param illegal");
        }
        return this.topicService.queryCanWrite(req.getTopicName(), req.getClusterId());
    }

    @GetMapping(value={"/consumerAuth"})
    @ResponseBody
    public String queryConsumerAuth(@RequestParam Map<String, String> req) throws Exception {
        String url = this.masterService.getQueryUrl(req);
        return this.masterService.queryMaster(url);
    }

    @GetMapping(value={"/topicConfig"})
    @ResponseBody
    public String queryTopicConfig(@RequestParam Map<String, String> req) throws Exception {
        String url = this.masterService.getQueryUrl(req);
        return this.masterService.queryMaster(url);
    }
}

