/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.controller.node;

import com.google.gson.Gson;
import java.util.Map;
import org.apache.inlong.tubemq.manager.controller.TubeMQResult;
import org.apache.inlong.tubemq.manager.controller.node.dto.MasterDto;
import org.apache.inlong.tubemq.manager.controller.node.request.AddBrokersReq;
import org.apache.inlong.tubemq.manager.controller.node.request.BaseReq;
import org.apache.inlong.tubemq.manager.controller.node.request.BrokerSetReadOrWriteReq;
import org.apache.inlong.tubemq.manager.controller.node.request.CloneBrokersReq;
import org.apache.inlong.tubemq.manager.controller.node.request.DeleteBrokerReq;
import org.apache.inlong.tubemq.manager.controller.node.request.OnlineOfflineBrokerReq;
import org.apache.inlong.tubemq.manager.controller.node.request.ReloadBrokerReq;
import org.apache.inlong.tubemq.manager.repository.MasterRepository;
import org.apache.inlong.tubemq.manager.service.interfaces.MasterService;
import org.apache.inlong.tubemq.manager.service.interfaces.NodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/v1/node"})
public class NodeController {
    private static final Logger log = LoggerFactory.getLogger(NodeController.class);
    private final Gson gson = new Gson();
    @Autowired
    NodeService nodeService;
    @Autowired
    MasterRepository masterRepository;
    @Autowired
    MasterService masterService;

    @RequestMapping(value={"/broker/status"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String queryBrokerDetail(@RequestParam Map<String, String> queryBody) throws Exception {
        String url = this.masterService.getQueryUrl(queryBody);
        return this.masterService.queryMaster(url);
    }

    @RequestMapping(value={"/broker/config"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String queryBrokerConfig(@RequestParam Map<String, String> queryBody) throws Exception {
        String url = this.masterService.getQueryUrl(queryBody);
        return this.masterService.queryMaster(url);
    }

    @RequestMapping(value={"/broker"})
    @ResponseBody
    public TubeMQResult brokerMethodProxy(@RequestParam String method, @RequestBody String req) throws Exception {
        switch (method) {
            case "clone": {
                return this.nodeService.cloneBrokersWithTopic((CloneBrokersReq)this.gson.fromJson(req, CloneBrokersReq.class));
            }
            case "add": {
                return this.masterService.baseRequestMaster((BaseReq)this.gson.fromJson(req, AddBrokersReq.class));
            }
            case "online": 
            case "offline": {
                return this.masterService.baseRequestMaster((BaseReq)this.gson.fromJson(req, OnlineOfflineBrokerReq.class));
            }
            case "reload": {
                return this.masterService.baseRequestMaster((BaseReq)this.gson.fromJson(req, ReloadBrokerReq.class));
            }
            case "delete": {
                return this.masterService.baseRequestMaster((BaseReq)this.gson.fromJson(req, DeleteBrokerReq.class));
            }
            case "setReadOrWrite": {
                return this.masterService.baseRequestMaster((BaseReq)this.gson.fromJson(req, BrokerSetReadOrWriteReq.class));
            }
        }
        return TubeMQResult.errorResult("no such method");
    }

    @RequestMapping(value={"/master"})
    @ResponseBody
    public TubeMQResult masterMethodProxy(@RequestParam String method, @RequestBody String req) {
        switch (method) {
            case "modify": {
                return this.nodeService.modifyMasterNode((MasterDto)this.gson.fromJson(req, MasterDto.class));
            }
        }
        return TubeMQResult.errorResult("no such method");
    }
}

