/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.controller.cluster;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.tubemq.manager.controller.TubeMQResult;
import org.apache.inlong.tubemq.manager.controller.cluster.dto.ClusterDto;
import org.apache.inlong.tubemq.manager.controller.cluster.request.AddClusterReq;
import org.apache.inlong.tubemq.manager.controller.cluster.request.DeleteClusterReq;
import org.apache.inlong.tubemq.manager.controller.cluster.vo.ClusterVo;
import org.apache.inlong.tubemq.manager.entry.ClusterEntry;
import org.apache.inlong.tubemq.manager.entry.MasterEntry;
import org.apache.inlong.tubemq.manager.service.TubeConst;
import org.apache.inlong.tubemq.manager.service.interfaces.ClusterService;
import org.apache.inlong.tubemq.manager.service.interfaces.MasterService;
import org.apache.inlong.tubemq.manager.utils.ConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/v1/cluster"})
public class ClusterController {
    private static final Logger log = LoggerFactory.getLogger(ClusterController.class);
    private final Gson gson = new Gson();
    @Autowired
    private ClusterService clusterService;
    @Autowired
    private MasterService masterService;

    @PostMapping(value={""})
    @ResponseBody
    public TubeMQResult clusterMethodProxy(@RequestParam String method, @RequestBody String req) {
        switch (method) {
            case "add": {
                return this.addNewCluster((AddClusterReq)this.gson.fromJson(req, AddClusterReq.class));
            }
            case "delete": {
                return this.deleteCluster((DeleteClusterReq)this.gson.fromJson(req, DeleteClusterReq.class));
            }
            case "modify": {
                return this.changeCluster((ClusterDto)this.gson.fromJson(req, ClusterDto.class));
            }
        }
        return TubeMQResult.errorResult("no such method");
    }

    private TubeMQResult changeCluster(ClusterDto clusterDto) {
        if (!clusterDto.legal()) {
            return TubeMQResult.errorResult("param illegal");
        }
        return this.clusterService.modifyCluster(clusterDto);
    }

    public TubeMQResult addNewCluster(AddClusterReq req) {
        if (!req.legal()) {
            return TubeMQResult.errorResult("param illegal");
        }
        TubeMQResult checkResult = this.masterService.checkMasterNodeStatus(req.getMasterIp(), req.getMasterWebPort());
        if (checkResult.getErrCode() != TubeConst.SUCCESS_CODE.intValue()) {
            return TubeMQResult.errorResult("please check master ip and webPort");
        }
        this.clusterService.addClusterAndMasterNode(req);
        return new TubeMQResult();
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    public TubeMQResult queryCluster(@RequestParam(required=false) Integer clusterId) {
        if (clusterId == null) {
            return this.queryAllClusterVo();
        }
        ClusterEntry clusterEntry = this.clusterService.getOneCluster(clusterId.intValue());
        if (clusterEntry == null) {
            return TubeMQResult.errorResult("no such cluster with id " + clusterId);
        }
        MasterEntry masterNode = this.masterService.getMasterNode(clusterEntry.getClusterId());
        TubeMQResult result = new TubeMQResult();
        result.setData(Lists.newArrayList((Object[])new ClusterVo[]{ConvertUtils.convertToClusterVo(clusterEntry, masterNode)}));
        return result;
    }

    private TubeMQResult queryAllClusterVo() {
        TubeMQResult result = new TubeMQResult();
        List<ClusterEntry> allClusters = this.clusterService.getAllClusters();
        ArrayList clusterVos = Lists.newArrayList();
        for (ClusterEntry cluster : allClusters) {
            MasterEntry masterNode = this.masterService.getMasterNode(cluster.getClusterId());
            ClusterVo clusterVo = ConvertUtils.convertToClusterVo(cluster, masterNode);
            clusterVos.add(clusterVo);
        }
        result.setData(clusterVos);
        return result;
    }

    public TubeMQResult deleteCluster(DeleteClusterReq req) {
        if (req.getClusterId() == null || StringUtils.isEmpty((CharSequence)req.getModifyUser())) {
            return TubeMQResult.errorResult("please input clusterId and modifyUser");
        }
        this.clusterService.deleteCluster(req.getClusterId());
        return new TubeMQResult();
    }

    @RequestMapping(value={"/query"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String queryInfo(@RequestParam Map<String, String> queryBody) throws Exception {
        String url = this.masterService.getQueryUrl(queryBody);
        return this.masterService.queryMaster(url);
    }
}

