/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.controller;

import com.google.gson.Gson;
import org.apache.inlong.tubemq.manager.enums.ErrorCode;

public class TubeMQResult {
    private String errMsg = "";
    private int errCode = 0;
    private boolean result = true;
    private Object data;
    private static Gson json = new Gson();

    public static TubeMQResult errorResult(String errorMsg) {
        return TubeMQResult.builder().errCode(-1).errMsg(errorMsg).result(false).data("").build();
    }

    public static TubeMQResult errorResult(ErrorCode errorCode) {
        return TubeMQResult.builder().errCode(errorCode.getCode()).errMsg(errorCode.getMessage()).result(false).data("").build();
    }

    public static TubeMQResult errorResult(String errorMsg, Integer errorCode) {
        return TubeMQResult.builder().errCode(errorCode).errMsg(errorMsg).result(false).data("").build();
    }

    public static TubeMQResult successResult() {
        return TubeMQResult.builder().errCode(0).result(true).data("").build();
    }

    public static TubeMQResult successResult(Object data) {
        return TubeMQResult.builder().errCode(0).result(true).data(data).build();
    }

    public static TubeMQResultBuilder builder() {
        return new TubeMQResultBuilder();
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public boolean isResult() {
        return this.result;
    }

    public Object getData() {
        return this.data;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TubeMQResult)) {
            return false;
        }
        TubeMQResult other = (TubeMQResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$errMsg = this.getErrMsg();
        String other$errMsg = other.getErrMsg();
        if (this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg)) {
            return false;
        }
        if (this.getErrCode() != other.getErrCode()) {
            return false;
        }
        if (this.isResult() != other.isResult()) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TubeMQResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $errMsg = this.getErrMsg();
        result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
        result = result * 59 + this.getErrCode();
        result = result * 59 + (this.isResult() ? 79 : 97);
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "TubeMQResult(errMsg=" + this.getErrMsg() + ", errCode=" + this.getErrCode() + ", result=" + this.isResult() + ", data=" + this.getData() + ")";
    }

    public TubeMQResult() {
    }

    public TubeMQResult(String errMsg, int errCode, boolean result, Object data) {
        this.errMsg = errMsg;
        this.errCode = errCode;
        this.result = result;
        this.data = data;
    }

    public static class TubeMQResultBuilder {
        private String errMsg;
        private int errCode;
        private boolean result;
        private Object data;

        TubeMQResultBuilder() {
        }

        public TubeMQResultBuilder errMsg(String errMsg) {
            this.errMsg = errMsg;
            return this;
        }

        public TubeMQResultBuilder errCode(int errCode) {
            this.errCode = errCode;
            return this;
        }

        public TubeMQResultBuilder result(boolean result) {
            this.result = result;
            return this;
        }

        public TubeMQResultBuilder data(Object data) {
            this.data = data;
            return this;
        }

        public TubeMQResult build() {
            return new TubeMQResult(this.errMsg, this.errCode, this.result, this.data);
        }

        public String toString() {
            return "TubeMQResult.TubeMQResultBuilder(errMsg=" + this.errMsg + ", errCode=" + this.errCode + ", result=" + this.result + ", data=" + this.data + ")";
        }
    }
}

