/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.client.config;

import org.apache.inlong.tubemq.corebase.cluster.MasterInfo;
import org.apache.inlong.tubemq.corebase.config.TLSConfig;
import org.apache.inlong.tubemq.corebase.utils.AddressUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corerpc.RpcConstants;

public class TubeClientConfig {
    private MasterInfo masterInfo;
    private long rpcReadTimeoutMs = 10000L;
    private int rpcConnProcessorCnt = RpcConstants.CFG_DEFAULT_CLIENT_WORKER_COUNT;
    private int rpcNettyWorkMemorySize = 0xA00000;
    private int rpcRspCallBackThreadCnt = 3;
    private long nettyWriteBufferHighWaterMark = 0x3200000L;
    private long nettyWriteBufferLowWaterMark = 0x500000L;
    private int maxRegisterRetryTimes = 5;
    private long regFailWaitPeriodMs = 1000L;
    private int maxHeartBeatRetryTimes = 5;
    private long heartbeatPeriodMs = 13000L;
    private long heartbeatPeriodAfterFail = 60000L;
    private long linkStatsDurationMs = 60000L;
    private long linkStatsForbiddenDurationMs = 1800000L;
    private int linkStatsMaxAllowedFailTimes = 5;
    private double linkStatsMaxForbiddenRate = 0.3;
    private long unAvailableFbdDurationMs = 50000L;
    private double maxSentForbiddenRate = 0.15;
    private long maxForbiddenCheckDuration = 30000L;
    private long sessionStatisticCheckDuration = 1000L;
    private double sessionWarnForbiddenRate = 0.2;
    private long sessionWarnDelayedMsgCount = 300000L;
    private long linkMaxAllowedDelayedMsgCount = 50000L;
    private long sessionMaxAllowedDelayedMsgCount = 500000L;
    private boolean enableUserAuthentic = false;
    private String usrName = "";
    private String usrPassWord = "";
    private TLSConfig tlsConfig = new TLSConfig();

    public TubeClientConfig(String masterAddrInfo) {
        this(new MasterInfo(masterAddrInfo));
    }

    public TubeClientConfig(MasterInfo masterInfo) {
        if (masterInfo == null) {
            throw new IllegalArgumentException("Illegal parameter: masterAddrInfo is null!");
        }
        this.masterInfo = masterInfo.clone();
        AddressUtils.getIPV4LocalAddress();
    }

    @Deprecated
    public TubeClientConfig(String localHostIP, String masterAddrInfo) {
        this(localHostIP, new MasterInfo(masterAddrInfo));
    }

    @Deprecated
    public TubeClientConfig(String localHostIP, MasterInfo masterInfo) {
        if (TStringUtils.isBlank((String)localHostIP)) {
            throw new IllegalArgumentException("Illegal parameter: localHostIP is blank!");
        }
        if ("127.0.0.1".equals(localHostIP)) {
            throw new IllegalArgumentException("Illegal parameter: localHostIP can't set to 127.0.0.1");
        }
        if (masterInfo == null) {
            throw new IllegalArgumentException("Illegal parameter: masterAddrInfo is null!");
        }
        this.masterInfo = masterInfo.clone();
        AddressUtils.validLocalIp((String)localHostIP.trim());
    }

    public MasterInfo getMasterInfo() {
        return this.masterInfo;
    }

    public long getRpcTimeoutMs() {
        return this.rpcReadTimeoutMs;
    }

    public void setRpcTimeoutMs(long rpcReadTimeoutMs) {
        this.rpcReadTimeoutMs = rpcReadTimeoutMs >= 600000L ? 600000L : (rpcReadTimeoutMs <= 3000L ? 3000L : rpcReadTimeoutMs);
    }

    public long getHeartbeatPeriodMs() {
        return this.heartbeatPeriodMs;
    }

    public void setHeartbeatPeriodMs(long heartbeatPeriodMs) {
        this.heartbeatPeriodMs = heartbeatPeriodMs;
    }

    public int getRpcConnProcessorCnt() {
        return this.rpcConnProcessorCnt;
    }

    public void setRpcConnProcessorCnt(int rpcConnProcessorCnt) {
        this.rpcConnProcessorCnt = rpcConnProcessorCnt <= 0 ? RpcConstants.CFG_DEFAULT_CLIENT_WORKER_COUNT : rpcConnProcessorCnt;
    }

    public long getUnAvailableFbdDurationMs() {
        return this.unAvailableFbdDurationMs;
    }

    public void setUnAvailableFbdDurationMs(long unAvailableFbdDurationMs) {
        this.unAvailableFbdDurationMs = unAvailableFbdDurationMs;
    }

    public int getRpcNettyWorkMemorySize() {
        return this.rpcNettyWorkMemorySize;
    }

    public void setRpcNettyWorkMemorySize(int rpcNettyWorkMemorySize) {
        this.rpcNettyWorkMemorySize = rpcNettyWorkMemorySize <= 0 ? 0xA00000 : rpcNettyWorkMemorySize;
    }

    public int getRpcRspCallBackThreadCnt() {
        return this.rpcRspCallBackThreadCnt;
    }

    public void setRpcRspCallBackThreadCnt(int rpcRspCallBackThreadCnt) {
        this.rpcRspCallBackThreadCnt = rpcRspCallBackThreadCnt <= 0 ? 3 : rpcRspCallBackThreadCnt;
    }

    public long getNettyWriteBufferHighWaterMark() {
        return this.nettyWriteBufferHighWaterMark;
    }

    public void setNettyWriteBufferHighWaterMark(long nettyWriteBufferHighWaterMark) {
        this.nettyWriteBufferHighWaterMark = nettyWriteBufferHighWaterMark >= Integer.MAX_VALUE ? 0x7FFFFFFEL : (nettyWriteBufferHighWaterMark <= 0L ? 0x3200000L : nettyWriteBufferHighWaterMark);
    }

    public long getNettyWriteBufferLowWaterMark() {
        return this.nettyWriteBufferLowWaterMark;
    }

    public void setNettyWriteBufferLowWaterMark(long nettyWriteBufferLowWaterMark) {
        this.nettyWriteBufferLowWaterMark = nettyWriteBufferLowWaterMark >= Integer.MAX_VALUE ? 0x7FFFFFFEL : (nettyWriteBufferLowWaterMark <= 0L ? 0x500000L : nettyWriteBufferLowWaterMark);
    }

    public int getMaxRegisterRetryTimes() {
        return this.maxRegisterRetryTimes;
    }

    public void setMaxRegisterRetryTimes(int maxRegisterRetryTimes) {
        this.maxRegisterRetryTimes = maxRegisterRetryTimes;
    }

    public long getRegFailWaitPeriodMs() {
        return this.regFailWaitPeriodMs;
    }

    public void setRegFailWaitPeriodMs(long regFailWaitPeriodMs) {
        this.regFailWaitPeriodMs = regFailWaitPeriodMs;
    }

    public int getMaxHeartBeatRetryTimes() {
        return this.maxHeartBeatRetryTimes;
    }

    public void setMaxHeartBeatRetryTimes(int maxHeartBeatRetryTimes) {
        this.maxHeartBeatRetryTimes = maxHeartBeatRetryTimes;
    }

    public long getHeartbeatPeriodAfterFail() {
        return this.heartbeatPeriodAfterFail;
    }

    public void setHeartbeatPeriodAfterFail(long heartbeatPeriodAfterFail) {
        this.heartbeatPeriodAfterFail = heartbeatPeriodAfterFail;
    }

    public long getLinkStatsDurationMs() {
        return this.linkStatsDurationMs;
    }

    public void setLinkStatsDurationMs(long linkStatsDurationMs) {
        this.linkStatsDurationMs = linkStatsDurationMs;
    }

    public long getLinkStatsForbiddenDurationMs() {
        return this.linkStatsForbiddenDurationMs;
    }

    public void setLinkStatsForbiddenDurationMs(long linkStatsForbiddenDurationMs) {
        this.linkStatsForbiddenDurationMs = linkStatsForbiddenDurationMs;
    }

    public int getLinkStatsMaxAllowedFailTimes() {
        return this.linkStatsMaxAllowedFailTimes;
    }

    public void setLinkStatsMaxAllowedFailTimes(int linkStatsMaxAllowedFailTimes) {
        this.linkStatsMaxAllowedFailTimes = linkStatsMaxAllowedFailTimes;
    }

    public double getLinkStatsMaxForbiddenRate() {
        return this.linkStatsMaxForbiddenRate;
    }

    public void setLinkStatsMaxForbiddenRate(double linkStatsMaxForbiddenRate) {
        this.linkStatsMaxForbiddenRate = linkStatsMaxForbiddenRate;
    }

    public double getMaxSentForbiddenRate() {
        return this.maxSentForbiddenRate;
    }

    public void setMaxSentForbiddenRate(double maxSentForbiddenRate) {
        this.maxSentForbiddenRate = maxSentForbiddenRate;
    }

    public long getMaxForbiddenCheckDuration() {
        return this.maxForbiddenCheckDuration;
    }

    public void setMaxForbiddenCheckDuration(long maxForbiddenCheckDuration) {
        this.maxForbiddenCheckDuration = maxForbiddenCheckDuration;
    }

    public long getSessionStatisticCheckDuration() {
        return this.sessionStatisticCheckDuration;
    }

    public void setSessionStatisticCheckDuration(long sessionStatisticCheckDuration) {
        this.sessionStatisticCheckDuration = sessionStatisticCheckDuration;
    }

    public double getSessionWarnForbiddenRate() {
        return this.sessionWarnForbiddenRate;
    }

    public void setSessionWarnForbiddenRate(double sessionWarnForbiddenRate) {
        this.sessionWarnForbiddenRate = sessionWarnForbiddenRate;
    }

    public long getSessionWarnDelayedMsgCount() {
        return this.sessionWarnDelayedMsgCount;
    }

    public void setSessionWarnDelayedMsgCount(long sessionWarnDelayedMsgCount) {
        this.sessionWarnDelayedMsgCount = sessionWarnDelayedMsgCount;
    }

    public long getLinkMaxAllowedDelayedMsgCount() {
        return this.linkMaxAllowedDelayedMsgCount;
    }

    public void setLinkMaxAllowedDelayedMsgCount(long linkMaxAllowedDelayedMsgCount) {
        this.linkMaxAllowedDelayedMsgCount = linkMaxAllowedDelayedMsgCount;
    }

    public long getSessionMaxAllowedDelayedMsgCount() {
        return this.sessionMaxAllowedDelayedMsgCount;
    }

    public void setSessionMaxAllowedDelayedMsgCount(long sessionMaxAllowedDelayedMsgCount) {
        this.sessionMaxAllowedDelayedMsgCount = sessionMaxAllowedDelayedMsgCount;
    }

    public void setAuthenticInfo(boolean needAuthentic, String usrName, String usrPassWord) {
        if (needAuthentic) {
            if (TStringUtils.isBlank((String)usrName)) {
                throw new IllegalArgumentException("Illegal parameter: usrName is Blank!");
            }
            if (TStringUtils.isBlank((String)usrPassWord)) {
                throw new IllegalArgumentException("Illegal parameter: usrPassWord is Blank!");
            }
        }
        this.enableUserAuthentic = needAuthentic;
        if (this.enableUserAuthentic) {
            this.usrName = usrName;
            this.usrPassWord = usrPassWord;
        } else {
            this.usrName = "";
            this.usrPassWord = "";
        }
    }

    public void setTLSEnableInfo(String trustStorePath, String trustStorePassword) {
        if (TStringUtils.isBlank((String)trustStorePath)) {
            throw new IllegalArgumentException("Illegal parameter: trustStorePath is Blank!");
        }
        if (TStringUtils.isBlank((String)trustStorePassword)) {
            throw new IllegalArgumentException("Illegal parameter: trustStorePassword is Blank!");
        }
        this.tlsConfig.setTlsEnable(true);
        this.tlsConfig.setTlsTrustStorePath(trustStorePath);
        this.tlsConfig.setTlsTrustStorePassword(trustStorePassword);
        this.tlsConfig.setTlsTwoWayAuthEnable(false);
    }

    public boolean isTlsEnable() {
        return this.tlsConfig.isTlsEnable();
    }

    public String getTrustStorePath() {
        return this.tlsConfig.getTlsTrustStorePath();
    }

    public String getTrustStorePassword() {
        return this.tlsConfig.getTlsTrustStorePassword();
    }

    public boolean isEnableTLSTwoWayAuthentic() {
        return this.tlsConfig.isTlsTwoWayAuthEnable();
    }

    public String getKeyStorePath() {
        return this.tlsConfig.getTlsKeyStorePath();
    }

    public String getKeyStorePassword() {
        return this.tlsConfig.getTlsKeyStorePassword();
    }

    public boolean isEnableUserAuthentic() {
        return this.enableUserAuthentic;
    }

    public String getUsrName() {
        return this.usrName;
    }

    public String getUsrPassWord() {
        return this.usrPassWord;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TubeClientConfig)) {
            return false;
        }
        TubeClientConfig that = (TubeClientConfig)o;
        if (this.rpcReadTimeoutMs != that.rpcReadTimeoutMs) {
            return false;
        }
        if (this.rpcConnProcessorCnt != that.rpcConnProcessorCnt) {
            return false;
        }
        if (this.rpcNettyWorkMemorySize != that.rpcNettyWorkMemorySize) {
            return false;
        }
        if (this.rpcRspCallBackThreadCnt != that.rpcRspCallBackThreadCnt) {
            return false;
        }
        if (this.nettyWriteBufferHighWaterMark != that.nettyWriteBufferHighWaterMark) {
            return false;
        }
        if (this.nettyWriteBufferLowWaterMark != that.nettyWriteBufferLowWaterMark) {
            return false;
        }
        if (this.maxRegisterRetryTimes != that.maxRegisterRetryTimes) {
            return false;
        }
        if (this.regFailWaitPeriodMs != that.regFailWaitPeriodMs) {
            return false;
        }
        if (this.maxHeartBeatRetryTimes != that.maxHeartBeatRetryTimes) {
            return false;
        }
        if (this.heartbeatPeriodMs != that.heartbeatPeriodMs) {
            return false;
        }
        if (this.heartbeatPeriodAfterFail != that.heartbeatPeriodAfterFail) {
            return false;
        }
        if (this.linkStatsDurationMs != that.linkStatsDurationMs) {
            return false;
        }
        if (this.linkStatsForbiddenDurationMs != that.linkStatsForbiddenDurationMs) {
            return false;
        }
        if (this.unAvailableFbdDurationMs != that.unAvailableFbdDurationMs) {
            return false;
        }
        if (this.linkStatsMaxAllowedFailTimes != that.linkStatsMaxAllowedFailTimes) {
            return false;
        }
        if (Double.compare(that.linkStatsMaxForbiddenRate, this.linkStatsMaxForbiddenRate) != 0) {
            return false;
        }
        if (Double.compare(that.maxSentForbiddenRate, this.maxSentForbiddenRate) != 0) {
            return false;
        }
        if (this.maxForbiddenCheckDuration != that.maxForbiddenCheckDuration) {
            return false;
        }
        if (this.sessionStatisticCheckDuration != that.sessionStatisticCheckDuration) {
            return false;
        }
        if (Double.compare(that.sessionWarnForbiddenRate, this.sessionWarnForbiddenRate) != 0) {
            return false;
        }
        if (this.sessionWarnDelayedMsgCount != that.sessionWarnDelayedMsgCount) {
            return false;
        }
        if (this.linkMaxAllowedDelayedMsgCount != that.linkMaxAllowedDelayedMsgCount) {
            return false;
        }
        if (this.sessionMaxAllowedDelayedMsgCount != that.sessionMaxAllowedDelayedMsgCount) {
            return false;
        }
        if (this.enableUserAuthentic != that.enableUserAuthentic) {
            return false;
        }
        if (!this.usrName.equals(that.usrName)) {
            return false;
        }
        if (!this.usrPassWord.equals(that.usrPassWord)) {
            return false;
        }
        if (!this.tlsConfig.equals((Object)that.tlsConfig)) {
            return false;
        }
        return this.masterInfo.equals((Object)that.masterInfo);
    }

    public String toJsonString() {
        int num = 0;
        String localAddress = null;
        try {
            localAddress = AddressUtils.getLocalAddress();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        StringBuilder sBuilder = new StringBuilder(512);
        sBuilder.append("{\"masterInfo\":[");
        for (String item : this.masterInfo.getAddrMap4Failover().keySet()) {
            if (num++ > 0) {
                sBuilder.append(",");
            }
            sBuilder.append("\"").append(item).append("\"");
        }
        return sBuilder.append("],\"rpcReadTimeoutMs\":").append(this.rpcReadTimeoutMs).append(",\"rpcConnProcessorCnt\":").append(this.rpcConnProcessorCnt).append(",\"rpcNettyWorkMemorySize\":").append(this.rpcNettyWorkMemorySize).append(",\"rpcRspCallBackThreadCnt\":").append(this.rpcRspCallBackThreadCnt).append(",\"nettyWriteBufferHighWaterMark\":").append(this.nettyWriteBufferHighWaterMark).append(",\"nettyWriteBufferLowWaterMark\":").append(this.nettyWriteBufferLowWaterMark).append(",\"maxRegisterRetryTimes\":").append(this.maxRegisterRetryTimes).append(",\"regFailWaitPeriodMs\":").append(this.regFailWaitPeriodMs).append(",\"maxHeartBeatRetryTimes\":").append(this.maxHeartBeatRetryTimes).append(",\"heartbeatPeriodMs\":").append(this.heartbeatPeriodMs).append(",\"heartbeatPeriodAfterFail\":").append(this.heartbeatPeriodAfterFail).append(",\"linkStatsDurationMs\":").append(this.linkStatsDurationMs).append(",\"linkStatsForbiddenDurationMs\":").append(this.linkStatsForbiddenDurationMs).append(",\"linkStatsMaxAllowedFailTimes\":").append(this.linkStatsMaxAllowedFailTimes).append(",\"linkStatsMaxForbiddenRate\":").append(this.linkStatsMaxForbiddenRate).append(",\"maxSentForbiddenRate\":").append(this.maxSentForbiddenRate).append(",\"maxForbiddenCheckDuration\":").append(this.maxForbiddenCheckDuration).append(",\"sessionStatisticCheckDuration\":").append(this.sessionStatisticCheckDuration).append(",\"sessionWarnForbiddenRate\":").append(this.sessionWarnForbiddenRate).append(",\"sessionWarnDelayedMsgCount\":").append(this.sessionWarnDelayedMsgCount).append(",\"linkMaxAllowedDelayedMsgCount\":").append(this.linkMaxAllowedDelayedMsgCount).append(",\"sessionMaxAllowedDelayedMsgCount\":").append(this.sessionMaxAllowedDelayedMsgCount).append(",\"unAvailableFbdDurationMs\":").append(this.unAvailableFbdDurationMs).append(",\"enableUserAuthentic\":").append(this.enableUserAuthentic).append(",\"usrName\":\"").append(this.usrName).append("\",\"usrPassWord\":\"").append(this.usrPassWord).append("\",\"localAddress\":\"").append(localAddress).append("\",").append(this.tlsConfig.toString()).append("}").toString();
    }
}

