/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.sort.protocol.sink.SinkInfo;
import org.apache.inlong.sort.protocol.source.SourceInfo;

public class DataFlowInfo
implements Serializable {
    private static final long serialVersionUID = 6549803844655330833L;
    private final long id;
    private final SourceInfo sourceInfo;
    private final SinkInfo sinkInfo;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Map<String, Object> properties;

    @JsonCreator
    public DataFlowInfo(@JsonProperty(value="id") long id, @JsonProperty(value="source_info") SourceInfo sourceInfo, @JsonProperty(value="sink_info") SinkInfo sinkInfo, @JsonProperty(value="properties") Map<String, Object> properties) {
        this.id = id;
        this.sourceInfo = Preconditions.checkNotNull(sourceInfo);
        this.sinkInfo = Preconditions.checkNotNull(sinkInfo);
        this.properties = properties == null ? new HashMap() : properties;
    }

    public DataFlowInfo(long id, SourceInfo sourceInfo, SinkInfo sinkInfo) {
        this.id = id;
        this.sourceInfo = sourceInfo;
        this.sinkInfo = sinkInfo;
        this.properties = new HashMap<String, Object>();
    }

    @JsonProperty(value="id")
    public long getId() {
        return this.id;
    }

    @JsonProperty(value="source_info")
    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    @JsonProperty(value="sink_info")
    public SinkInfo getSinkInfo() {
        return this.sinkInfo;
    }

    @JsonProperty(value="properties")
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFlowInfo other = (DataFlowInfo)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.sourceInfo, other.sourceInfo) && Objects.equals(this.sinkInfo, other.sinkInfo) && Objects.equals(this.properties, other.properties);
    }
}

