/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.common;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.sort.formats.common.BasicFormatInfo;
import org.apache.inlong.sort.formats.common.DateTypeInfo;

public class DateFormatInfo
implements BasicFormatInfo<java.sql.Date> {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_FORMAT = "format";
    @JsonProperty(value="format")
    @Nonnull
    private final String format;
    @JsonIgnore
    @Nullable
    private final SimpleDateFormat simpleDateFormat;

    @JsonCreator
    public DateFormatInfo(@JsonProperty(value="format") @Nonnull String format) {
        this.format = format;
        this.simpleDateFormat = !format.equals("SECONDS") && !format.equals("MILLIS") && !format.equals("MICROS") ? new SimpleDateFormat(format) : null;
    }

    public DateFormatInfo() {
        this("yyyy-MM-dd");
    }

    @Nonnull
    public String getFormat() {
        return this.format;
    }

    @Override
    public DateTypeInfo getTypeInfo() {
        return DateTypeInfo.INSTANCE;
    }

    @Override
    public String serialize(java.sql.Date date) {
        switch (this.format) {
            case "MICROS": {
                long millis = date.getTime();
                long micros = TimeUnit.MILLISECONDS.toMicros(millis);
                return Long.toString(micros);
            }
            case "MILLIS": {
                long millis = date.getTime();
                return Long.toString(millis);
            }
            case "SECONDS": {
                long millis = date.getTime();
                long seconds = TimeUnit.MILLISECONDS.toSeconds(millis);
                return Long.toString(seconds);
            }
        }
        if (this.simpleDateFormat == null) {
            throw new IllegalStateException();
        }
        return this.simpleDateFormat.format(date);
    }

    @Override
    public java.sql.Date deserialize(String text) throws ParseException {
        switch (this.format) {
            case "MICROS": {
                long micros = Long.parseLong(text.trim());
                long millis = TimeUnit.MICROSECONDS.toMillis(micros);
                return new java.sql.Date(millis);
            }
            case "MILLIS": {
                long millis = Long.parseLong(text.trim());
                return new java.sql.Date(millis);
            }
            case "SECONDS": {
                long seconds = Long.parseLong(text.trim());
                long millis = TimeUnit.SECONDS.toMillis(seconds);
                return new java.sql.Date(millis);
            }
        }
        if (this.simpleDateFormat == null) {
            throw new IllegalStateException();
        }
        Date jDate = this.simpleDateFormat.parse(text.trim());
        return new java.sql.Date(jDate.getTime());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateFormatInfo that = (DateFormatInfo)o;
        return this.format.equals(that.format);
    }

    public int hashCode() {
        return Objects.hash(this.format);
    }

    public String toString() {
        return "DateFormatInfo{format='" + this.format + '\'' + '}';
    }
}

