/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.openapi.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.pojo.agent.AgentHeartbeatRequest;
import org.apache.inlong.manager.common.pojo.agent.AgentStatusReportRequest;
import org.apache.inlong.manager.common.pojo.agent.AgentSysConfig;
import org.apache.inlong.manager.common.pojo.agent.AgentSysconfRequest;
import org.apache.inlong.manager.common.pojo.agent.CheckAgentTaskConfRequest;
import org.apache.inlong.manager.common.pojo.agent.ConfirmAgentIpRequest;
import org.apache.inlong.manager.common.pojo.agent.FileAgentCommandInfo;
import org.apache.inlong.manager.common.pojo.agent.FileAgentTaskConfig;
import org.apache.inlong.manager.common.pojo.agent.FileAgentTaskInfo;
import org.apache.inlong.manager.service.core.AgentHeartBeatService;
import org.apache.inlong.manager.service.core.AgentSysConfigService;
import org.apache.inlong.manager.service.core.AgentTaskService;
import org.apache.inlong.manager.service.core.ClusterInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/agent"})
@Api(tags={"Agent Config"})
public class AgentController {
    @Autowired
    private ClusterInfoService clusterInfoService;
    @Autowired
    private AgentTaskService agentTaskService;
    @Autowired
    private AgentSysConfigService agentSysConfigService;
    @Autowired
    private AgentHeartBeatService agentHeartBeatService;

    @GetMapping(value={"/getVirtualIp"})
    @ApiOperation(value="get inlong manager ip list")
    public Response<List<String>> getVirtualIp() {
        return Response.success((Object)this.clusterInfoService.listClusterIpByType("inlong-openapi"));
    }

    @PostMapping(value={"/file_agent/taskconf"})
    @ApiOperation(value="fetch file access task")
    public Response<FileAgentTaskInfo> getFileAgentTask(@RequestBody FileAgentCommandInfo info) {
        return Response.success((Object)this.agentTaskService.getFileAgentTask(info));
    }

    @PostMapping(value={"/file_agent/confirmAgentIp"})
    @ApiOperation(value="confirm current agent ip")
    public Response<String> confirmAgentIp(@RequestBody ConfirmAgentIpRequest info) {
        return Response.success((Object)this.agentTaskService.confirmAgentIp(info));
    }

    @PostMapping(value={"/file_agent/queryAgentSysconf"})
    @ApiOperation(value="query agent system config")
    public Response<AgentSysConfig> getAgentSysConf(@RequestBody AgentSysconfRequest info) {
        return Response.success((Object)this.agentSysConfigService.getAgentSysConfig(info));
    }

    @PostMapping(value={"/file_agent/heartbeat"})
    @ApiOperation(value="agent heartbeat report")
    public Response<String> heartbeat(@RequestBody AgentHeartbeatRequest info) {
        return Response.success((Object)this.agentHeartBeatService.heartbeat(info));
    }

    @PostMapping(value={"/file_agent/checkAgentTaskConf"})
    @ApiOperation(value="agent data source comparison")
    public Response<List<FileAgentTaskConfig>> checkAgentTaskConf(@RequestBody CheckAgentTaskConfRequest info) {
        return Response.success((Object)this.agentTaskService.checkAgentTaskConf(info));
    }

    @PostMapping(value={"/file_agent/reportAgentStatus"})
    @ApiOperation(value="agent status report")
    public Response<String> reportAgentStatus(@RequestBody AgentStatusReportRequest info) {
        return Response.success((Object)this.agentTaskService.reportAgentStatus(info));
    }
}

