/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.openapi.config;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnMissingBean(value={RestTemplate.class})
@ConfigurationProperties(prefix="common.http-client")
public class RestTemplateConfig {
    private Integer maxTotal = 5000;
    private Integer defaultMaxPerRoute = 2000;
    private Integer validateAfterInactivity = 5000;
    private int connectionTimeout = 3000;
    private int readTimeout = 5000;
    private int connectionRequestTimeout = 3000;

    @Bean
    public PoolingHttpClientConnectionManager httpClientConnectionManager() {
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager httpClientConnectionManager = new PoolingHttpClientConnectionManager(registry);
        httpClientConnectionManager.setMaxTotal(this.maxTotal.intValue());
        httpClientConnectionManager.setDefaultMaxPerRoute(this.defaultMaxPerRoute.intValue());
        httpClientConnectionManager.setValidateAfterInactivity(this.validateAfterInactivity.intValue());
        return httpClientConnectionManager;
    }

    @Bean
    public HttpClient httpClient() {
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)this.httpClientConnectionManager()).setKeepAliveStrategy((ConnectionKeepAliveStrategy)CustomConnectionKeepAliveStrategy.INSTANCE).build();
    }

    @Bean
    public HttpComponentsClientHttpRequestFactory clientHttpRequestFactory() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory(this.httpClient());
        factory.setConnectTimeout(this.connectionTimeout);
        factory.setReadTimeout(this.readTimeout);
        factory.setConnectionRequestTimeout(this.connectionRequestTimeout);
        return factory;
    }

    @Bean
    public RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory((ClientHttpRequestFactory)this.clientHttpRequestFactory());
        restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler());
        this.setRestTemplateEncode(restTemplate);
        return restTemplate;
    }

    private void setRestTemplateEncode(RestTemplate restTemplate) {
        if (null == restTemplate || ObjectUtils.isEmpty((Object)restTemplate.getMessageConverters())) {
            return;
        }
        List messageConverters = restTemplate.getMessageConverters();
        for (int i = 0; i < messageConverters.size(); ++i) {
            HttpMessageConverter httpMessageConverter = (HttpMessageConverter)messageConverters.get(i);
            if (!httpMessageConverter.getClass().equals(StringHttpMessageConverter.class)) continue;
            messageConverters.set(i, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        }
    }

    public static class CustomConnectionKeepAliveStrategy
    implements ConnectionKeepAliveStrategy {
        public static CustomConnectionKeepAliveStrategy INSTANCE = new CustomConnectionKeepAliveStrategy();

        private CustomConnectionKeepAliveStrategy() {
        }

        public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
            return 30000L;
        }
    }
}

