/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.openapi.auth;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.inlong.manager.common.util.LoginUserUtil;
import org.apache.inlong.manager.openapi.auth.MockAuthenticationToken;
import org.apache.inlong.manager.service.core.RoleService;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.beans.factory.annotation.Autowired;

public class WebAuthorizingRealm
extends AuthorizingRealm {
    @Autowired
    private RoleService roleService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof MockAuthenticationToken;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        String username = (String)this.getAvailablePrincipal(principalCollection);
        if (username != null) {
            info.setRoles((Set)Sets.newHashSet((Iterable)this.roleService.listByUser(username)));
            LoginUserUtil.getLoginUserDetail().setRoles(info.getRoles());
        }
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        String username = (String)authenticationToken.getPrincipal();
        if (authenticationToken instanceof MockAuthenticationToken) {
            return new SimpleAuthenticationInfo((Object)username, (Object)"", username);
        }
        throw new AuthenticationException("No Authentication");
    }
}

