/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.openapi.auth;

import java.util.LinkedHashMap;
import org.apache.inlong.manager.common.enums.Env;
import org.apache.inlong.manager.openapi.auth.AuthenticationFilter;
import org.apache.inlong.manager.openapi.auth.WebAuthorizingRealm;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroConfig {
    @Value(value="${spring.profiles.active}")
    private String env;

    @Bean
    public AuthorizingRealm shiroRealm() {
        WebAuthorizingRealm authorizingRealm = new WebAuthorizingRealm();
        authorizingRealm.setCredentialsMatcher(new CredentialsMatcher(){

            public boolean doCredentialsMatch(AuthenticationToken authenticationToken, AuthenticationInfo authenticationInfo) {
                return true;
            }
        });
        return authorizingRealm;
    }

    @Bean
    public WebSecurityManager securityManager() {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm((Realm)this.shiroRealm());
        return securityManager;
    }

    @Bean
    public ShiroFilterFactoryBean shiroFilter() {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager((SecurityManager)this.securityManager());
        LinkedHashMap<String, AuthenticationFilter> filters = new LinkedHashMap<String, AuthenticationFilter>();
        filters.put("authc", new AuthenticationFilter(!Env.PROD.equals((Object)Env.forName((String)this.env))));
        shiroFilterFactoryBean.setFilters(filters);
        LinkedHashMap<String, String> pathDefinitions = new LinkedHashMap<String, String>();
        pathDefinitions.put("xxx", "anon");
        shiroFilterFactoryBean.setFilterChainDefinitionMap(pathDefinitions);
        return shiroFilterFactoryBean;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor() {
        AuthorizationAttributeSourceAdvisor advisor = new AuthorizationAttributeSourceAdvisor();
        advisor.setSecurityManager((SecurityManager)this.securityManager());
        return advisor;
    }
}

