/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.exceptions.JsonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public static String toJson(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass() == String.class) {
            return (String)obj;
        }
        try {
            return MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            log.error("JSON transform error: " + obj, (Throwable)e);
            throw new JsonException("JSON transform error");
        }
    }

    public static <T> T parse(String json, TypeReference<T> type) {
        try {
            return (T)MAPPER.readValue(json, type);
        }
        catch (IOException e) {
            log.error("JSON transform error: " + json, (Throwable)e);
            throw new JsonException("JSON transform error");
        }
    }

    public static JsonNode parse(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return MAPPER.readTree(json);
        }
        catch (IOException e) {
            log.error("JSON transform error: " + json, (Throwable)e);
            throw new JsonException("JSON transform error");
        }
    }

    public static <T> T parse(String json, Class<T> tClass) {
        try {
            return (T)MAPPER.readValue(json, tClass);
        }
        catch (IOException e) {
            log.error("JSON transform error: " + json, (Throwable)e);
            throw new JsonException("JSON transform error");
        }
    }

    public static <T> T parse(String json, JavaType javaType) {
        try {
            return (T)MAPPER.readValue(json, javaType);
        }
        catch (IOException e) {
            log.error("JSON transform error: " + json, (Throwable)e);
            throw new JsonException("JSON transform error");
        }
    }

    public static <E> List<E> parseList(String json, Class<E> eClass) {
        try {
            return (List)MAPPER.readValue(json, (JavaType)MAPPER.getTypeFactory().constructCollectionType(List.class, eClass));
        }
        catch (IOException e) {
            log.error("JSON transform error: " + json, (Throwable)e);
            throw new JsonException("JSON transform error");
        }
    }

    public static <K, V> Map<K, V> parseMap(String json, Class<K> kClass, Class<V> vClass) {
        try {
            return (Map)MAPPER.readValue(json, (JavaType)MAPPER.getTypeFactory().constructMapType(Map.class, kClass, vClass));
        }
        catch (IOException e) {
            log.error("JSON transform error: " + json, (Throwable)e);
            throw new JsonException("JSON transform error");
        }
    }

    static {
        MAPPER.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

