/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.user;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.enums.UserTypeEnum;
import org.apache.inlong.manager.common.util.Preconditions;

@ApiModel(value="User info")
public class UserInfo {
    private Integer id;
    @ApiModelProperty(value="type: 0 - manager, 1 - operator")
    private Integer type;
    @ApiModelProperty(value="username")
    private String username;
    @ApiModelProperty(value="password")
    private String password;
    @ApiModelProperty(value="valid days")
    private Integer validDays;

    public void checkValid() {
        Preconditions.checkNotEmpty(this.username, "username should not be empty");
        Preconditions.checkNotEmpty(this.password, "password should not be empty");
        Preconditions.checkNotNull((Object)this.validDays, "valid days should not be empty");
        UserTypeEnum userType = UserTypeEnum.parse(this.type);
        Preconditions.checkNotNull((Object)userType, "user type incorrect");
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getType() {
        return this.type;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getValidDays() {
        return this.validDays;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setValidDays(Integer validDays) {
        this.validDays = validDays;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserInfo)) {
            return false;
        }
        UserInfo other = (UserInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$validDays = this.getValidDays();
        Integer other$validDays = other.getValidDays();
        if (this$validDays == null ? other$validDays != null : !((Object)this$validDays).equals(other$validDays)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $validDays = this.getValidDays();
        result = result * 59 + ($validDays == null ? 43 : ((Object)$validDays).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "UserInfo(id=" + this.getId() + ", type=" + this.getType() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", validDays=" + this.getValidDays() + ")";
    }
}

