/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.util;

import com.fasterxml.jackson.databind.JavaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.workflow.exception.FormParseException;
import org.apache.inlong.manager.workflow.model.definition.Process;
import org.apache.inlong.manager.workflow.model.definition.ProcessForm;
import org.apache.inlong.manager.workflow.model.definition.Task;
import org.apache.inlong.manager.workflow.model.definition.TaskForm;
import org.apache.inlong.manager.workflow.model.definition.UserTask;
import org.apache.inlong.manager.workflow.model.instance.TaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowFormParserUtils {
    private static final Logger log = LoggerFactory.getLogger(WorkflowFormParserUtils.class);

    public static <T extends TaskForm> T parseTaskForm(TaskInstance taskInstance, Process process) throws FormParseException {
        Preconditions.checkNotNull((Object)taskInstance, (String)"taskInstance can't be null");
        Preconditions.checkNotNull((Object)process, (String)"process can't be null");
        if (StringUtils.isEmpty((CharSequence)taskInstance.getFormData())) {
            return null;
        }
        Task task = process.getTaskByName(taskInstance.getName());
        Preconditions.checkNotNull((Object)task, () -> "user task not exist " + taskInstance.getName());
        Preconditions.checkTrue((boolean)(task instanceof UserTask), () -> "task should be userTask " + taskInstance.getName());
        UserTask userTask = (UserTask)task;
        try {
            JavaType javaType = JsonUtils.MAPPER.constructType(userTask.getFormClass());
            return (T)((TaskForm)JsonUtils.parse((String)taskInstance.getFormData(), (JavaType)javaType));
        }
        catch (Exception e) {
            log.error("task form parse failed! formData is: {}", (Object)taskInstance.getFormData(), (Object)e);
            throw new FormParseException("task form parse failed!");
        }
    }

    public static <T extends ProcessForm> T parseProcessForm(String formDate, Process process) throws FormParseException {
        Preconditions.checkNotNull((Object)process, (String)"process can't be null");
        if (StringUtils.isEmpty((CharSequence)formDate)) {
            return null;
        }
        try {
            JavaType javaType = JsonUtils.MAPPER.constructType(process.getFormClass());
            return (T)((ProcessForm)JsonUtils.parse((String)formDate, (JavaType)javaType));
        }
        catch (Exception e) {
            log.error("process form parse failed! formData is: {}", (Object)formDate, (Object)e);
            throw new FormParseException("process form parse failed!");
        }
    }
}

