/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.model.view;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.workflow.model.TaskState;
import org.apache.inlong.manager.workflow.model.instance.TaskInstance;

@ApiModel(value="Approval task information")
public class TaskView {
    @ApiModelProperty(value="approval task ID")
    private Integer id;
    @ApiModelProperty(value="Task type")
    private String type;
    @ApiModelProperty(value="application form ID")
    private Integer processInstId;
    @ApiModelProperty(value="process name")
    private String processName;
    @ApiModelProperty(value="process display name")
    private String processDisplayName;
    @ApiModelProperty(value="task name-english key")
    private String name;
    @ApiModelProperty(value="task display name")
    private String displayName;
    @ApiModelProperty(value="applicant")
    private String applicant;
    @ApiModelProperty(value="set approver")
    private List<String> approvers;
    @ApiModelProperty(value="actual operation approver")
    private String operator;
    @ApiModelProperty(value="task status")
    private TaskState state;
    @ApiModelProperty(value="remarks information")
    private String remark;
    @ApiModelProperty(value="current task form information")
    private Object formData;
    @ApiModelProperty(value="start time")
    private Date startTime;
    @ApiModelProperty(value="end time")
    private Date endTime;
    @ApiModelProperty(value="extended Information")
    private Object ext;

    public static TaskView fromTaskInstance(TaskInstance taskInstance) {
        return TaskView.builder().id(taskInstance.getId()).type(taskInstance.getType()).processInstId(taskInstance.getProcessInstId()).processName(taskInstance.getProcessName()).processDisplayName(taskInstance.getProcessDisplayName()).name(taskInstance.getName()).displayName(taskInstance.getDisplayName()).applicant(taskInstance.getApplicant()).approvers(Arrays.asList(taskInstance.getApprovers().split(","))).operator(taskInstance.getOperator()).state(TaskState.valueOf(taskInstance.getState())).remark(taskInstance.getRemark()).formData(JsonUtils.parse((String)taskInstance.getFormData())).startTime(taskInstance.getStartTime()).endTime(taskInstance.getEndTime()).ext(JsonUtils.parse((String)taskInstance.getExt())).build();
    }

    public static TaskViewBuilder builder() {
        return new TaskViewBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public Integer getProcessInstId() {
        return this.processInstId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getProcessDisplayName() {
        return this.processDisplayName;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getApplicant() {
        return this.applicant;
    }

    public List<String> getApprovers() {
        return this.approvers;
    }

    public String getOperator() {
        return this.operator;
    }

    public TaskState getState() {
        return this.state;
    }

    public String getRemark() {
        return this.remark;
    }

    public Object getFormData() {
        return this.formData;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Object getExt() {
        return this.ext;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setProcessInstId(Integer processInstId) {
        this.processInstId = processInstId;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public void setProcessDisplayName(String processDisplayName) {
        this.processDisplayName = processDisplayName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setApplicant(String applicant) {
        this.applicant = applicant;
    }

    public void setApprovers(List<String> approvers) {
        this.approvers = approvers;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setState(TaskState state) {
        this.state = state;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setFormData(Object formData) {
        this.formData = formData;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setExt(Object ext) {
        this.ext = ext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskView)) {
            return false;
        }
        TaskView other = (TaskView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$processInstId = this.getProcessInstId();
        Integer other$processInstId = other.getProcessInstId();
        if (this$processInstId == null ? other$processInstId != null : !((Object)this$processInstId).equals(other$processInstId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$processName = this.getProcessName();
        String other$processName = other.getProcessName();
        if (this$processName == null ? other$processName != null : !this$processName.equals(other$processName)) {
            return false;
        }
        String this$processDisplayName = this.getProcessDisplayName();
        String other$processDisplayName = other.getProcessDisplayName();
        if (this$processDisplayName == null ? other$processDisplayName != null : !this$processDisplayName.equals(other$processDisplayName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$applicant = this.getApplicant();
        String other$applicant = other.getApplicant();
        if (this$applicant == null ? other$applicant != null : !this$applicant.equals(other$applicant)) {
            return false;
        }
        List<String> this$approvers = this.getApprovers();
        List<String> other$approvers = other.getApprovers();
        if (this$approvers == null ? other$approvers != null : !((Object)this$approvers).equals(other$approvers)) {
            return false;
        }
        String this$operator = this.getOperator();
        String other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
            return false;
        }
        TaskState this$state = this.getState();
        TaskState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        Object this$formData = this.getFormData();
        Object other$formData = other.getFormData();
        if (this$formData == null ? other$formData != null : !this$formData.equals(other$formData)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        Object this$ext = this.getExt();
        Object other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !this$ext.equals(other$ext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $processInstId = this.getProcessInstId();
        result = result * 59 + ($processInstId == null ? 43 : ((Object)$processInstId).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $processName = this.getProcessName();
        result = result * 59 + ($processName == null ? 43 : $processName.hashCode());
        String $processDisplayName = this.getProcessDisplayName();
        result = result * 59 + ($processDisplayName == null ? 43 : $processDisplayName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $applicant = this.getApplicant();
        result = result * 59 + ($applicant == null ? 43 : $applicant.hashCode());
        List<String> $approvers = this.getApprovers();
        result = result * 59 + ($approvers == null ? 43 : ((Object)$approvers).hashCode());
        String $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
        TaskState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        Object $formData = this.getFormData();
        result = result * 59 + ($formData == null ? 43 : $formData.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        Object $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : $ext.hashCode());
        return result;
    }

    public String toString() {
        return "TaskView(id=" + this.getId() + ", type=" + this.getType() + ", processInstId=" + this.getProcessInstId() + ", processName=" + this.getProcessName() + ", processDisplayName=" + this.getProcessDisplayName() + ", name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", applicant=" + this.getApplicant() + ", approvers=" + this.getApprovers() + ", operator=" + this.getOperator() + ", state=" + (Object)((Object)this.getState()) + ", remark=" + this.getRemark() + ", formData=" + this.getFormData() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", ext=" + this.getExt() + ")";
    }

    public TaskView() {
    }

    public TaskView(Integer id, String type, Integer processInstId, String processName, String processDisplayName, String name, String displayName, String applicant, List<String> approvers, String operator, TaskState state, String remark, Object formData, Date startTime, Date endTime, Object ext) {
        this.id = id;
        this.type = type;
        this.processInstId = processInstId;
        this.processName = processName;
        this.processDisplayName = processDisplayName;
        this.name = name;
        this.displayName = displayName;
        this.applicant = applicant;
        this.approvers = approvers;
        this.operator = operator;
        this.state = state;
        this.remark = remark;
        this.formData = formData;
        this.startTime = startTime;
        this.endTime = endTime;
        this.ext = ext;
    }

    public static class TaskViewBuilder {
        private Integer id;
        private String type;
        private Integer processInstId;
        private String processName;
        private String processDisplayName;
        private String name;
        private String displayName;
        private String applicant;
        private List<String> approvers;
        private String operator;
        private TaskState state;
        private String remark;
        private Object formData;
        private Date startTime;
        private Date endTime;
        private Object ext;

        TaskViewBuilder() {
        }

        public TaskViewBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public TaskViewBuilder type(String type) {
            this.type = type;
            return this;
        }

        public TaskViewBuilder processInstId(Integer processInstId) {
            this.processInstId = processInstId;
            return this;
        }

        public TaskViewBuilder processName(String processName) {
            this.processName = processName;
            return this;
        }

        public TaskViewBuilder processDisplayName(String processDisplayName) {
            this.processDisplayName = processDisplayName;
            return this;
        }

        public TaskViewBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TaskViewBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public TaskViewBuilder applicant(String applicant) {
            this.applicant = applicant;
            return this;
        }

        public TaskViewBuilder approvers(List<String> approvers) {
            this.approvers = approvers;
            return this;
        }

        public TaskViewBuilder operator(String operator) {
            this.operator = operator;
            return this;
        }

        public TaskViewBuilder state(TaskState state) {
            this.state = state;
            return this;
        }

        public TaskViewBuilder remark(String remark) {
            this.remark = remark;
            return this;
        }

        public TaskViewBuilder formData(Object formData) {
            this.formData = formData;
            return this;
        }

        public TaskViewBuilder startTime(Date startTime) {
            this.startTime = startTime;
            return this;
        }

        public TaskViewBuilder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        public TaskViewBuilder ext(Object ext) {
            this.ext = ext;
            return this;
        }

        public TaskView build() {
            return new TaskView(this.id, this.type, this.processInstId, this.processName, this.processDisplayName, this.name, this.displayName, this.applicant, this.approvers, this.operator, this.state, this.remark, this.formData, this.startTime, this.endTime, this.ext);
        }

        public String toString() {
            return "TaskView.TaskViewBuilder(id=" + this.id + ", type=" + this.type + ", processInstId=" + this.processInstId + ", processName=" + this.processName + ", processDisplayName=" + this.processDisplayName + ", name=" + this.name + ", displayName=" + this.displayName + ", applicant=" + this.applicant + ", approvers=" + this.approvers + ", operator=" + this.operator + ", state=" + (Object)((Object)this.state) + ", remark=" + this.remark + ", formData=" + this.formData + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", ext=" + this.ext + ")";
        }
    }
}

