/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.model.view;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.workflow.model.ProcessState;
import org.apache.inlong.manager.workflow.model.instance.ProcessInstance;

@ApiModel(value="Application form information")
public class ProcessView {
    @ApiModelProperty(value="application form ID")
    private Integer id;
    @ApiModelProperty(value="process name-English key")
    private String name;
    @ApiModelProperty(value="process display name-Chinese")
    private String displayName;
    @ApiModelProperty(value="process classification")
    private String type;
    @ApiModelProperty(value="process title")
    private String title;
    @ApiModelProperty(value="applicant")
    private String applicant;
    @ApiModelProperty(value="process status")
    private ProcessState state;
    @ApiModelProperty(value="application time")
    private Date startTime;
    @ApiModelProperty(value="end Time")
    private Date endTime;
    @ApiModelProperty(value="form information-JSON")
    private Object formData;
    @ApiModelProperty(value="extended Information-JSON")
    private Object ext;

    public static ProcessView fromProcessInstance(ProcessInstance processInstance) {
        return ProcessView.builder().id(processInstance.getId()).name(processInstance.getName()).displayName(processInstance.getDisplayName()).type(processInstance.getType()).title(processInstance.getTitle()).applicant(processInstance.getApplicant()).state(ProcessState.valueOf(processInstance.getState())).startTime(processInstance.getStartTime()).endTime(processInstance.getEndTime()).formData(JsonUtils.parse((String)processInstance.getFormData())).ext(JsonUtils.parse((String)processInstance.getExt())).build();
    }

    public static ProcessViewBuilder builder() {
        return new ProcessViewBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getApplicant() {
        return this.applicant;
    }

    public ProcessState getState() {
        return this.state;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Object getFormData() {
        return this.formData;
    }

    public Object getExt() {
        return this.ext;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setApplicant(String applicant) {
        this.applicant = applicant;
    }

    public void setState(ProcessState state) {
        this.state = state;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setFormData(Object formData) {
        this.formData = formData;
    }

    public void setExt(Object ext) {
        this.ext = ext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessView)) {
            return false;
        }
        ProcessView other = (ProcessView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$applicant = this.getApplicant();
        String other$applicant = other.getApplicant();
        if (this$applicant == null ? other$applicant != null : !this$applicant.equals(other$applicant)) {
            return false;
        }
        ProcessState this$state = this.getState();
        ProcessState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        Object this$formData = this.getFormData();
        Object other$formData = other.getFormData();
        if (this$formData == null ? other$formData != null : !this$formData.equals(other$formData)) {
            return false;
        }
        Object this$ext = this.getExt();
        Object other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !this$ext.equals(other$ext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProcessView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $applicant = this.getApplicant();
        result = result * 59 + ($applicant == null ? 43 : $applicant.hashCode());
        ProcessState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        Object $formData = this.getFormData();
        result = result * 59 + ($formData == null ? 43 : $formData.hashCode());
        Object $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : $ext.hashCode());
        return result;
    }

    public String toString() {
        return "ProcessView(id=" + this.getId() + ", name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", type=" + this.getType() + ", title=" + this.getTitle() + ", applicant=" + this.getApplicant() + ", state=" + (Object)((Object)this.getState()) + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", formData=" + this.getFormData() + ", ext=" + this.getExt() + ")";
    }

    public ProcessView() {
    }

    public ProcessView(Integer id, String name, String displayName, String type, String title, String applicant, ProcessState state, Date startTime, Date endTime, Object formData, Object ext) {
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.type = type;
        this.title = title;
        this.applicant = applicant;
        this.state = state;
        this.startTime = startTime;
        this.endTime = endTime;
        this.formData = formData;
        this.ext = ext;
    }

    public static class ProcessViewBuilder {
        private Integer id;
        private String name;
        private String displayName;
        private String type;
        private String title;
        private String applicant;
        private ProcessState state;
        private Date startTime;
        private Date endTime;
        private Object formData;
        private Object ext;

        ProcessViewBuilder() {
        }

        public ProcessViewBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public ProcessViewBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ProcessViewBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ProcessViewBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ProcessViewBuilder title(String title) {
            this.title = title;
            return this;
        }

        public ProcessViewBuilder applicant(String applicant) {
            this.applicant = applicant;
            return this;
        }

        public ProcessViewBuilder state(ProcessState state) {
            this.state = state;
            return this;
        }

        public ProcessViewBuilder startTime(Date startTime) {
            this.startTime = startTime;
            return this;
        }

        public ProcessViewBuilder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        public ProcessViewBuilder formData(Object formData) {
            this.formData = formData;
            return this;
        }

        public ProcessViewBuilder ext(Object ext) {
            this.ext = ext;
            return this;
        }

        public ProcessView build() {
            return new ProcessView(this.id, this.name, this.displayName, this.type, this.title, this.applicant, this.state, this.startTime, this.endTime, this.formData, this.ext);
        }

        public String toString() {
            return "ProcessView.ProcessViewBuilder(id=" + this.id + ", name=" + this.name + ", displayName=" + this.displayName + ", type=" + this.type + ", title=" + this.title + ", applicant=" + this.applicant + ", state=" + (Object)((Object)this.state) + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", formData=" + this.formData + ", ext=" + this.ext + ")";
        }
    }
}

