/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.model.view;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.workflow.model.ProcessState;
import org.apache.inlong.manager.workflow.model.instance.ProcessInstance;
import org.apache.inlong.manager.workflow.model.view.TaskListView;

@ApiModel(value="Application list view")
public class ProcessListView {
    @ApiModelProperty(value="application form ID")
    private Integer id;
    @ApiModelProperty(value="process name-English key")
    private String name;
    @ApiModelProperty(value="process display name")
    private String displayName;
    @ApiModelProperty(value="process classification")
    private String type;
    @ApiModelProperty(value="process title")
    private String title;
    @ApiModelProperty(value="applicant")
    private String applicant;
    @ApiModelProperty(value="process status")
    private ProcessState state;
    @ApiModelProperty(value="application time")
    private Date startTime;
    @ApiModelProperty(value="end time")
    private Date endTime;
    @ApiModelProperty(value="Tasks currently to be done")
    private List<TaskListView> currentTasks;
    @ApiModelProperty(value="Extra information shown in the list")
    private Map<String, Object> showInList;

    public static ProcessListView fromProcessInstance(ProcessInstance processInstance) {
        return ProcessListView.builder().id(processInstance.getId()).name(processInstance.getName()).displayName(processInstance.getDisplayName()).type(processInstance.getType()).title(processInstance.getTitle()).applicant(processInstance.getApplicant()).state(ProcessState.valueOf(processInstance.getState())).startTime(processInstance.getStartTime()).endTime(processInstance.getEndTime()).build();
    }

    public static ProcessListViewBuilder builder() {
        return new ProcessListViewBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getApplicant() {
        return this.applicant;
    }

    public ProcessState getState() {
        return this.state;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public List<TaskListView> getCurrentTasks() {
        return this.currentTasks;
    }

    public Map<String, Object> getShowInList() {
        return this.showInList;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setApplicant(String applicant) {
        this.applicant = applicant;
    }

    public void setState(ProcessState state) {
        this.state = state;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setCurrentTasks(List<TaskListView> currentTasks) {
        this.currentTasks = currentTasks;
    }

    public void setShowInList(Map<String, Object> showInList) {
        this.showInList = showInList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessListView)) {
            return false;
        }
        ProcessListView other = (ProcessListView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$applicant = this.getApplicant();
        String other$applicant = other.getApplicant();
        if (this$applicant == null ? other$applicant != null : !this$applicant.equals(other$applicant)) {
            return false;
        }
        ProcessState this$state = this.getState();
        ProcessState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        List<TaskListView> this$currentTasks = this.getCurrentTasks();
        List<TaskListView> other$currentTasks = other.getCurrentTasks();
        if (this$currentTasks == null ? other$currentTasks != null : !((Object)this$currentTasks).equals(other$currentTasks)) {
            return false;
        }
        Map<String, Object> this$showInList = this.getShowInList();
        Map<String, Object> other$showInList = other.getShowInList();
        return !(this$showInList == null ? other$showInList != null : !((Object)this$showInList).equals(other$showInList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProcessListView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $applicant = this.getApplicant();
        result = result * 59 + ($applicant == null ? 43 : $applicant.hashCode());
        ProcessState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        List<TaskListView> $currentTasks = this.getCurrentTasks();
        result = result * 59 + ($currentTasks == null ? 43 : ((Object)$currentTasks).hashCode());
        Map<String, Object> $showInList = this.getShowInList();
        result = result * 59 + ($showInList == null ? 43 : ((Object)$showInList).hashCode());
        return result;
    }

    public String toString() {
        return "ProcessListView(id=" + this.getId() + ", name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", type=" + this.getType() + ", title=" + this.getTitle() + ", applicant=" + this.getApplicant() + ", state=" + (Object)((Object)this.getState()) + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", currentTasks=" + this.getCurrentTasks() + ", showInList=" + this.getShowInList() + ")";
    }

    public ProcessListView() {
    }

    public ProcessListView(Integer id, String name, String displayName, String type, String title, String applicant, ProcessState state, Date startTime, Date endTime, List<TaskListView> currentTasks, Map<String, Object> showInList) {
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.type = type;
        this.title = title;
        this.applicant = applicant;
        this.state = state;
        this.startTime = startTime;
        this.endTime = endTime;
        this.currentTasks = currentTasks;
        this.showInList = showInList;
    }

    public static class ProcessListViewBuilder {
        private Integer id;
        private String name;
        private String displayName;
        private String type;
        private String title;
        private String applicant;
        private ProcessState state;
        private Date startTime;
        private Date endTime;
        private List<TaskListView> currentTasks;
        private Map<String, Object> showInList;

        ProcessListViewBuilder() {
        }

        public ProcessListViewBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public ProcessListViewBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ProcessListViewBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ProcessListViewBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ProcessListViewBuilder title(String title) {
            this.title = title;
            return this;
        }

        public ProcessListViewBuilder applicant(String applicant) {
            this.applicant = applicant;
            return this;
        }

        public ProcessListViewBuilder state(ProcessState state) {
            this.state = state;
            return this;
        }

        public ProcessListViewBuilder startTime(Date startTime) {
            this.startTime = startTime;
            return this;
        }

        public ProcessListViewBuilder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        public ProcessListViewBuilder currentTasks(List<TaskListView> currentTasks) {
            this.currentTasks = currentTasks;
            return this;
        }

        public ProcessListViewBuilder showInList(Map<String, Object> showInList) {
            this.showInList = showInList;
            return this;
        }

        public ProcessListView build() {
            return new ProcessListView(this.id, this.name, this.displayName, this.type, this.title, this.applicant, this.state, this.startTime, this.endTime, this.currentTasks, this.showInList);
        }

        public String toString() {
            return "ProcessListView.ProcessListViewBuilder(id=" + this.id + ", name=" + this.name + ", displayName=" + this.displayName + ", type=" + this.type + ", title=" + this.title + ", applicant=" + this.applicant + ", state=" + (Object)((Object)this.state) + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", currentTasks=" + this.currentTasks + ", showInList=" + this.showInList + ")";
        }
    }
}

