/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.model.view;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import org.apache.inlong.manager.workflow.model.instance.EventLog;

@ApiModel(value="Workflow event log query conditions")
public class EventLogView {
    @ApiModelProperty(value="id")
    private Integer id;
    @ApiModelProperty(value="process ID")
    private Integer processInstId;
    @ApiModelProperty(value="process name ")
    private String processName;
    @ApiModelProperty(value="Process display name")
    private String processDisplayName;
    @ApiModelProperty(value="business ID")
    private String businessId;
    @ApiModelProperty(value="task ID")
    private Integer taskInstId;
    @ApiModelProperty(value="the name of the element that triggered the event")
    private String elementName;
    @ApiModelProperty(value="The name of the element that triggered the event")
    private String elementDisplayName;
    @ApiModelProperty(value="event type")
    private String eventType;
    @ApiModelProperty(value="event")
    private String event;
    @ApiModelProperty(value="Listener name")
    private String listener;
    @ApiModelProperty(value="status")
    private Integer state;
    @ApiModelProperty(value="Is it synchronized")
    private Boolean async;
    @ApiModelProperty(value="Execute IP")
    private String ip;
    @ApiModelProperty(value="start time ")
    private Date startTime;
    @ApiModelProperty(value="end time")
    private Date endTime;
    @ApiModelProperty(value="exception")
    private String exception;

    public static EventLogView fromEventLog(EventLog eventLog, boolean includeException) {
        if (eventLog == null) {
            return null;
        }
        return EventLogView.builder().id(eventLog.getId()).processInstId(eventLog.getProcessInstId()).processName(eventLog.getProcessName()).processDisplayName(eventLog.getProcessDisplayName()).businessId(eventLog.getBusinessId()).taskInstId(eventLog.getTaskInstId()).elementName(eventLog.getElementName()).elementDisplayName(eventLog.getElementDisplayName()).eventType(eventLog.getEventType()).event(eventLog.getEvent()).listener(eventLog.getListener()).state(eventLog.getState()).async(eventLog.getAsync()).ip(eventLog.getIp()).startTime(eventLog.getStartTime()).endTime(eventLog.getEndTime()).exception(includeException ? eventLog.getException() : null).build();
    }

    public static EventLogViewBuilder builder() {
        return new EventLogViewBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getProcessInstId() {
        return this.processInstId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getProcessDisplayName() {
        return this.processDisplayName;
    }

    public String getBusinessId() {
        return this.businessId;
    }

    public Integer getTaskInstId() {
        return this.taskInstId;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getElementDisplayName() {
        return this.elementDisplayName;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEvent() {
        return this.event;
    }

    public String getListener() {
        return this.listener;
    }

    public Integer getState() {
        return this.state;
    }

    public Boolean getAsync() {
        return this.async;
    }

    public String getIp() {
        return this.ip;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getException() {
        return this.exception;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setProcessInstId(Integer processInstId) {
        this.processInstId = processInstId;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public void setProcessDisplayName(String processDisplayName) {
        this.processDisplayName = processDisplayName;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public void setTaskInstId(Integer taskInstId) {
        this.taskInstId = taskInstId;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public void setElementDisplayName(String elementDisplayName) {
        this.elementDisplayName = elementDisplayName;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setListener(String listener) {
        this.listener = listener;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public void setAsync(Boolean async) {
        this.async = async;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventLogView)) {
            return false;
        }
        EventLogView other = (EventLogView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$processInstId = this.getProcessInstId();
        Integer other$processInstId = other.getProcessInstId();
        if (this$processInstId == null ? other$processInstId != null : !((Object)this$processInstId).equals(other$processInstId)) {
            return false;
        }
        Integer this$taskInstId = this.getTaskInstId();
        Integer other$taskInstId = other.getTaskInstId();
        if (this$taskInstId == null ? other$taskInstId != null : !((Object)this$taskInstId).equals(other$taskInstId)) {
            return false;
        }
        Integer this$state = this.getState();
        Integer other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        Boolean this$async = this.getAsync();
        Boolean other$async = other.getAsync();
        if (this$async == null ? other$async != null : !((Object)this$async).equals(other$async)) {
            return false;
        }
        String this$processName = this.getProcessName();
        String other$processName = other.getProcessName();
        if (this$processName == null ? other$processName != null : !this$processName.equals(other$processName)) {
            return false;
        }
        String this$processDisplayName = this.getProcessDisplayName();
        String other$processDisplayName = other.getProcessDisplayName();
        if (this$processDisplayName == null ? other$processDisplayName != null : !this$processDisplayName.equals(other$processDisplayName)) {
            return false;
        }
        String this$businessId = this.getBusinessId();
        String other$businessId = other.getBusinessId();
        if (this$businessId == null ? other$businessId != null : !this$businessId.equals(other$businessId)) {
            return false;
        }
        String this$elementName = this.getElementName();
        String other$elementName = other.getElementName();
        if (this$elementName == null ? other$elementName != null : !this$elementName.equals(other$elementName)) {
            return false;
        }
        String this$elementDisplayName = this.getElementDisplayName();
        String other$elementDisplayName = other.getElementDisplayName();
        if (this$elementDisplayName == null ? other$elementDisplayName != null : !this$elementDisplayName.equals(other$elementDisplayName)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        String this$listener = this.getListener();
        String other$listener = other.getListener();
        if (this$listener == null ? other$listener != null : !this$listener.equals(other$listener)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$exception = this.getException();
        String other$exception = other.getException();
        return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventLogView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $processInstId = this.getProcessInstId();
        result = result * 59 + ($processInstId == null ? 43 : ((Object)$processInstId).hashCode());
        Integer $taskInstId = this.getTaskInstId();
        result = result * 59 + ($taskInstId == null ? 43 : ((Object)$taskInstId).hashCode());
        Integer $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        Boolean $async = this.getAsync();
        result = result * 59 + ($async == null ? 43 : ((Object)$async).hashCode());
        String $processName = this.getProcessName();
        result = result * 59 + ($processName == null ? 43 : $processName.hashCode());
        String $processDisplayName = this.getProcessDisplayName();
        result = result * 59 + ($processDisplayName == null ? 43 : $processDisplayName.hashCode());
        String $businessId = this.getBusinessId();
        result = result * 59 + ($businessId == null ? 43 : $businessId.hashCode());
        String $elementName = this.getElementName();
        result = result * 59 + ($elementName == null ? 43 : $elementName.hashCode());
        String $elementDisplayName = this.getElementDisplayName();
        result = result * 59 + ($elementDisplayName == null ? 43 : $elementDisplayName.hashCode());
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        String $listener = this.getListener();
        result = result * 59 + ($listener == null ? 43 : $listener.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        return result;
    }

    public String toString() {
        return "EventLogView(id=" + this.getId() + ", processInstId=" + this.getProcessInstId() + ", processName=" + this.getProcessName() + ", processDisplayName=" + this.getProcessDisplayName() + ", businessId=" + this.getBusinessId() + ", taskInstId=" + this.getTaskInstId() + ", elementName=" + this.getElementName() + ", elementDisplayName=" + this.getElementDisplayName() + ", eventType=" + this.getEventType() + ", event=" + this.getEvent() + ", listener=" + this.getListener() + ", state=" + this.getState() + ", async=" + this.getAsync() + ", ip=" + this.getIp() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", exception=" + this.getException() + ")";
    }

    public EventLogView() {
    }

    public EventLogView(Integer id, Integer processInstId, String processName, String processDisplayName, String businessId, Integer taskInstId, String elementName, String elementDisplayName, String eventType, String event, String listener, Integer state, Boolean async, String ip, Date startTime, Date endTime, String exception) {
        this.id = id;
        this.processInstId = processInstId;
        this.processName = processName;
        this.processDisplayName = processDisplayName;
        this.businessId = businessId;
        this.taskInstId = taskInstId;
        this.elementName = elementName;
        this.elementDisplayName = elementDisplayName;
        this.eventType = eventType;
        this.event = event;
        this.listener = listener;
        this.state = state;
        this.async = async;
        this.ip = ip;
        this.startTime = startTime;
        this.endTime = endTime;
        this.exception = exception;
    }

    public static class EventLogViewBuilder {
        private Integer id;
        private Integer processInstId;
        private String processName;
        private String processDisplayName;
        private String businessId;
        private Integer taskInstId;
        private String elementName;
        private String elementDisplayName;
        private String eventType;
        private String event;
        private String listener;
        private Integer state;
        private Boolean async;
        private String ip;
        private Date startTime;
        private Date endTime;
        private String exception;

        EventLogViewBuilder() {
        }

        public EventLogViewBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public EventLogViewBuilder processInstId(Integer processInstId) {
            this.processInstId = processInstId;
            return this;
        }

        public EventLogViewBuilder processName(String processName) {
            this.processName = processName;
            return this;
        }

        public EventLogViewBuilder processDisplayName(String processDisplayName) {
            this.processDisplayName = processDisplayName;
            return this;
        }

        public EventLogViewBuilder businessId(String businessId) {
            this.businessId = businessId;
            return this;
        }

        public EventLogViewBuilder taskInstId(Integer taskInstId) {
            this.taskInstId = taskInstId;
            return this;
        }

        public EventLogViewBuilder elementName(String elementName) {
            this.elementName = elementName;
            return this;
        }

        public EventLogViewBuilder elementDisplayName(String elementDisplayName) {
            this.elementDisplayName = elementDisplayName;
            return this;
        }

        public EventLogViewBuilder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public EventLogViewBuilder event(String event) {
            this.event = event;
            return this;
        }

        public EventLogViewBuilder listener(String listener) {
            this.listener = listener;
            return this;
        }

        public EventLogViewBuilder state(Integer state) {
            this.state = state;
            return this;
        }

        public EventLogViewBuilder async(Boolean async) {
            this.async = async;
            return this;
        }

        public EventLogViewBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public EventLogViewBuilder startTime(Date startTime) {
            this.startTime = startTime;
            return this;
        }

        public EventLogViewBuilder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        public EventLogViewBuilder exception(String exception) {
            this.exception = exception;
            return this;
        }

        public EventLogView build() {
            return new EventLogView(this.id, this.processInstId, this.processName, this.processDisplayName, this.businessId, this.taskInstId, this.elementName, this.elementDisplayName, this.eventType, this.event, this.listener, this.state, this.async, this.ip, this.startTime, this.endTime, this.exception);
        }

        public String toString() {
            return "EventLogView.EventLogViewBuilder(id=" + this.id + ", processInstId=" + this.processInstId + ", processName=" + this.processName + ", processDisplayName=" + this.processDisplayName + ", businessId=" + this.businessId + ", taskInstId=" + this.taskInstId + ", elementName=" + this.elementName + ", elementDisplayName=" + this.elementDisplayName + ", eventType=" + this.eventType + ", event=" + this.event + ", listener=" + this.listener + ", state=" + this.state + ", async=" + this.async + ", ip=" + this.ip + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", exception=" + this.exception + ")";
        }
    }
}

