/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.model.definition;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.workflow.exception.WorkflowException;
import org.apache.inlong.manager.workflow.model.Action;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.apache.inlong.manager.workflow.model.definition.Element;
import org.apache.inlong.manager.workflow.model.definition.Task;

public class ServiceTask
extends Task {
    private static final Set<Action> SUPPORTED_ACTIONS = ImmutableSet.of((Object)((Object)Action.COMPLETE), (Object)((Object)Action.CANCEL), (Object)((Object)Action.TERMINATE));

    @Override
    public Action defaultNextAction() {
        return Action.COMPLETE;
    }

    @Override
    protected Set<Action> supportedActions() {
        return SUPPORTED_ACTIONS;
    }

    @Override
    public List<Element> getNextList(Action action, WorkflowContext context) {
        Preconditions.checkTrue((boolean)this.supportedActions().contains((Object)action), () -> "not support action " + (Object)((Object)action) + " ,action should in one of " + this.supportedActions());
        switch (action) {
            case COMPLETE: {
                return super.getNextList(action, context);
            }
            case CANCEL: 
            case TERMINATE: {
                return Collections.singletonList(context.getProcess().getEndEvent());
            }
        }
        throw new WorkflowException("unknown action " + (Object)((Object)action));
    }
}

