/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.model;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.inlong.manager.workflow.exception.WorkflowException;
import org.apache.inlong.manager.workflow.model.Action;
import org.apache.inlong.manager.workflow.model.definition.Element;
import org.apache.inlong.manager.workflow.model.definition.Process;
import org.apache.inlong.manager.workflow.model.definition.ProcessForm;
import org.apache.inlong.manager.workflow.model.definition.Task;
import org.apache.inlong.manager.workflow.model.definition.TaskForm;
import org.apache.inlong.manager.workflow.model.instance.ProcessInstance;
import org.apache.inlong.manager.workflow.model.instance.TaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowContext
implements Cloneable {
    private static final Logger log = LoggerFactory.getLogger(WorkflowContext.class);
    private String applicant;
    private Process process;
    private ProcessForm processForm;
    private Element currentElement;
    private ProcessInstance processInstance;
    private List<TaskInstance> newTaskInstances = Lists.newArrayList();
    private ActionContext actionContext;

    public String getApplicant() {
        return this.applicant;
    }

    public WorkflowContext setApplicant(String applicant) {
        this.applicant = applicant;
        return this;
    }

    public Process getProcess() {
        return this.process;
    }

    public WorkflowContext setProcess(Process process) {
        this.process = process;
        return this;
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public WorkflowContext setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
        return this;
    }

    public ProcessForm getProcessForm() {
        return this.processForm;
    }

    public WorkflowContext setProcessForm(ProcessForm processForm) {
        this.processForm = processForm;
        return this;
    }

    public Element getCurrentElement() {
        return this.currentElement;
    }

    public WorkflowContext setCurrentElement(Element currentElement) {
        this.currentElement = currentElement;
        return this;
    }

    public ActionContext getActionContext() {
        return this.actionContext;
    }

    public WorkflowContext setActionContext(ActionContext actionContext) {
        this.actionContext = actionContext;
        return this;
    }

    public List<TaskInstance> getNewTaskInstances() {
        return this.newTaskInstances;
    }

    public WorkflowContext setNewTaskInstances(List<TaskInstance> newTaskInstances) {
        this.newTaskInstances = newTaskInstances;
        return this;
    }

    public WorkflowContext clone() {
        try {
            WorkflowContext workflowContext = (WorkflowContext)super.clone();
            workflowContext.setProcess(this.process.clone());
            workflowContext.setCurrentElement(this.currentElement.clone());
            if (this.actionContext != null) {
                workflowContext.setActionContext(this.actionContext.clone());
            }
            return workflowContext;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new WorkflowException("workflow context clone failed" + this.getProcessInstance().getId());
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowContext)) {
            return false;
        }
        WorkflowContext other = (WorkflowContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$applicant = this.getApplicant();
        String other$applicant = other.getApplicant();
        if (this$applicant == null ? other$applicant != null : !this$applicant.equals(other$applicant)) {
            return false;
        }
        Process this$process = this.getProcess();
        Process other$process = other.getProcess();
        if (this$process == null ? other$process != null : !((Object)this$process).equals(other$process)) {
            return false;
        }
        ProcessForm this$processForm = this.getProcessForm();
        ProcessForm other$processForm = other.getProcessForm();
        if (this$processForm == null ? other$processForm != null : !this$processForm.equals(other$processForm)) {
            return false;
        }
        Element this$currentElement = this.getCurrentElement();
        Element other$currentElement = other.getCurrentElement();
        if (this$currentElement == null ? other$currentElement != null : !((Object)this$currentElement).equals(other$currentElement)) {
            return false;
        }
        ProcessInstance this$processInstance = this.getProcessInstance();
        ProcessInstance other$processInstance = other.getProcessInstance();
        if (this$processInstance == null ? other$processInstance != null : !this$processInstance.equals(other$processInstance)) {
            return false;
        }
        List<TaskInstance> this$newTaskInstances = this.getNewTaskInstances();
        List<TaskInstance> other$newTaskInstances = other.getNewTaskInstances();
        if (this$newTaskInstances == null ? other$newTaskInstances != null : !((Object)this$newTaskInstances).equals(other$newTaskInstances)) {
            return false;
        }
        ActionContext this$actionContext = this.getActionContext();
        ActionContext other$actionContext = other.getActionContext();
        return !(this$actionContext == null ? other$actionContext != null : !this$actionContext.equals(other$actionContext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkflowContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicant = this.getApplicant();
        result = result * 59 + ($applicant == null ? 43 : $applicant.hashCode());
        Process $process = this.getProcess();
        result = result * 59 + ($process == null ? 43 : ((Object)$process).hashCode());
        ProcessForm $processForm = this.getProcessForm();
        result = result * 59 + ($processForm == null ? 43 : $processForm.hashCode());
        Element $currentElement = this.getCurrentElement();
        result = result * 59 + ($currentElement == null ? 43 : ((Object)$currentElement).hashCode());
        ProcessInstance $processInstance = this.getProcessInstance();
        result = result * 59 + ($processInstance == null ? 43 : $processInstance.hashCode());
        List<TaskInstance> $newTaskInstances = this.getNewTaskInstances();
        result = result * 59 + ($newTaskInstances == null ? 43 : ((Object)$newTaskInstances).hashCode());
        ActionContext $actionContext = this.getActionContext();
        result = result * 59 + ($actionContext == null ? 43 : $actionContext.hashCode());
        return result;
    }

    public String toString() {
        return "WorkflowContext(applicant=" + this.getApplicant() + ", process=" + this.getProcess() + ", processForm=" + this.getProcessForm() + ", currentElement=" + this.getCurrentElement() + ", processInstance=" + this.getProcessInstance() + ", newTaskInstances=" + this.getNewTaskInstances() + ", actionContext=" + this.getActionContext() + ")";
    }

    public static class ActionContext
    implements Cloneable {
        private Action action;
        private String operator;
        private String remark;
        private TaskForm form;
        private TaskInstance actionTaskInstance;
        private Task task;
        private List<String> transferToUsers;

        public Action getAction() {
            return this.action;
        }

        public ActionContext setAction(Action action) {
            this.action = action;
            return this;
        }

        public String getOperator() {
            return this.operator;
        }

        public ActionContext setOperator(String operator) {
            this.operator = operator;
            return this;
        }

        public String getRemark() {
            return this.remark;
        }

        public ActionContext setRemark(String remark) {
            this.remark = remark;
            return this;
        }

        public TaskForm getForm() {
            return this.form;
        }

        public ActionContext setForm(TaskForm form) {
            this.form = form;
            return this;
        }

        public TaskInstance getActionTaskInstance() {
            return this.actionTaskInstance;
        }

        public ActionContext setActionTaskInstance(TaskInstance actionTaskInstance) {
            this.actionTaskInstance = actionTaskInstance;
            return this;
        }

        public Task getTask() {
            return this.task;
        }

        public ActionContext setTask(Task task) {
            this.task = task;
            return this;
        }

        public List<String> getTransferToUsers() {
            return this.transferToUsers;
        }

        public ActionContext setTransferToUsers(List<String> transferToUsers) {
            this.transferToUsers = transferToUsers;
            return this;
        }

        protected ActionContext clone() throws CloneNotSupportedException {
            ActionContext actionContext = (ActionContext)super.clone();
            if (this.task != null) {
                actionContext.setTask(this.task.clone());
            }
            return actionContext;
        }
    }
}

