/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.model;

import org.apache.inlong.manager.workflow.core.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.exception.WorkflowException;
import org.apache.inlong.manager.workflow.model.TaskState;

public enum Action {
    START("initiation process"),
    APPROVE("agree"),
    REJECT("reject"),
    CANCEL("withdrawal"),
    TRANSFER("Turn to do"),
    TERMINATE("abandoned"),
    COMPLETE("automatic completion");

    private String displayName;

    private Action(String displayName) {
        this.displayName = displayName;
    }

    public static Action fromTaskEvent(TaskEvent taskEvent) {
        switch (taskEvent) {
            case CREATE: {
                return null;
            }
            case APPROVE: {
                return APPROVE;
            }
            case REJECT: {
                return REJECT;
            }
            case TRANSFER: {
                return TRANSFER;
            }
            case CANCEL: {
                return CANCEL;
            }
            case COMPLETE: 
            case FAIL: {
                return COMPLETE;
            }
            case TERMINATE: {
                return TERMINATE;
            }
        }
        throw new WorkflowException("unknow taskEvent " + taskEvent);
    }

    public static Action fromTaskState(TaskState state) {
        switch (state) {
            case APPROVED: {
                return APPROVE;
            }
            case REJECTED: {
                return REJECT;
            }
            case CANCELED: {
                return CANCEL;
            }
            case TRANSFERED: {
                return TRANSFER;
            }
            case TERMINATED: {
                return TERMINATE;
            }
            case COMPLETED: 
            case FAILED: {
                return COMPLETE;
            }
        }
        throw new WorkflowException("unknow state " + (Object)((Object)state));
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

