/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.processor;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.workflow.core.WorkflowDataAccessor;
import org.apache.inlong.manager.workflow.core.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventNotifier;
import org.apache.inlong.manager.workflow.core.impl.WorkflowEventNotifier;
import org.apache.inlong.manager.workflow.core.processor.AbstractTaskProcessor;
import org.apache.inlong.manager.workflow.exception.WorkflowException;
import org.apache.inlong.manager.workflow.model.Action;
import org.apache.inlong.manager.workflow.model.TaskState;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.apache.inlong.manager.workflow.model.definition.Element;
import org.apache.inlong.manager.workflow.model.definition.UserTask;
import org.apache.inlong.manager.workflow.model.instance.ProcessInstance;
import org.apache.inlong.manager.workflow.model.instance.TaskInstance;

public class UserTaskProcessor
extends AbstractTaskProcessor<UserTask> {
    private static final Set<Action> SHOULD_CHECK_OPERATOR_ACTIONS = ImmutableSet.of((Object)((Object)Action.APPROVE), (Object)((Object)Action.REJECT), (Object)((Object)Action.TRANSFER));
    private static final Set<Action> SUPPORT_ACTIONS = ImmutableSet.of((Object)((Object)Action.APPROVE), (Object)((Object)Action.REJECT), (Object)((Object)Action.TRANSFER), (Object)((Object)Action.CANCEL), (Object)((Object)Action.TERMINATE));
    private TaskEventNotifier taskEventNotifier;

    public UserTaskProcessor(WorkflowDataAccessor workflowDataAccessor, WorkflowEventNotifier workflowEventNotifier) {
        super(workflowDataAccessor);
        this.taskEventNotifier = workflowEventNotifier.getTaskEventNotifier();
    }

    @Override
    public Class<UserTask> watch() {
        return UserTask.class;
    }

    @Override
    public void create(UserTask userTask, WorkflowContext context) {
        ProcessInstance processInstance = context.getProcessInstance();
        List<String> approvers = userTask.getApproverAssign().assign(context);
        Preconditions.checkNotEmpty(approvers, (String)("can't assign approvers for task :" + userTask.getDisplayName()));
        if (!userTask.isNeedAllApprove()) {
            approvers = Collections.singletonList(StringUtils.join(approvers, (String)","));
        }
        approvers.stream().map(approver -> this.createTaskInstance(userTask, processInstance, (String)approver)).forEach(context.getNewTaskInstances()::add);
        this.taskEventNotifier.notify(TaskEvent.CREATE, context);
    }

    @Override
    public boolean pendingForAction(WorkflowContext context) {
        return true;
    }

    @Override
    public boolean complete(WorkflowContext context) {
        WorkflowContext.ActionContext actionContext = context.getActionContext();
        Preconditions.checkTrue((boolean)SUPPORT_ACTIONS.contains((Object)actionContext.getAction()), () -> "userTask not support action:" + (Object)((Object)actionContext.getAction()));
        TaskInstance taskInstance = actionContext.getActionTaskInstance();
        Preconditions.checkTrue((boolean)TaskState.PENDING.name().equalsIgnoreCase(taskInstance.getState()), (String)"task state should be pending");
        this.checkOperator(actionContext);
        this.completeTaskInstance(actionContext);
        this.taskEventNotifier.notify(this.toTaskEvent(actionContext.getAction()), context);
        return true;
    }

    @Override
    public List<Element> next(UserTask userTask, WorkflowContext context) {
        WorkflowContext.ActionContext actionContext = context.getActionContext();
        if (userTask.isNeedAllApprove()) {
            TaskInstance taskInstance = actionContext.getActionTaskInstance();
            int pendingTaskCount = this.workflowDataAccessor.taskInstanceStorage().countTask(taskInstance.getProcessInstId(), taskInstance.getName(), TaskState.PENDING);
            if (pendingTaskCount > 0) {
                return Lists.newArrayList();
            }
        }
        return super.next(userTask, context);
    }

    private TaskInstance createTaskInstance(UserTask userTask, ProcessInstance processInstance, String approvers) {
        TaskInstance taskInstance = new TaskInstance().setType(UserTask.class.getSimpleName()).setProcessInstId(processInstance.getId()).setProcessName(processInstance.getName()).setProcessDisplayName(processInstance.getDisplayName()).setApplicant(processInstance.getApplicant()).setName(userTask.getName()).setDisplayName(userTask.getDisplayName()).setApprovers(approvers).setState(TaskState.PENDING.name()).setStartTime(new Date());
        this.workflowDataAccessor.taskInstanceStorage().insert(taskInstance);
        Preconditions.checkNotNull((Object)taskInstance.getId(), (String)"task instance id cannot be null");
        return taskInstance;
    }

    private void checkOperator(WorkflowContext.ActionContext actionContext) {
        TaskInstance taskInstance = actionContext.getActionTaskInstance();
        if (!SHOULD_CHECK_OPERATOR_ACTIONS.contains((Object)actionContext.getAction())) {
            return;
        }
        boolean operatorIsApprover = ArrayUtils.contains((Object[])taskInstance.getApprovers().split(","), (Object)actionContext.getOperator());
        if (!operatorIsApprover) {
            throw new WorkflowException("current operator " + actionContext.getOperator() + " not in approvers list:" + taskInstance.getApprovers());
        }
    }

    private void completeTaskInstance(WorkflowContext.ActionContext actionContext) {
        TaskInstance taskInstance = actionContext.getActionTaskInstance();
        TaskState taskState = this.toTaskState(actionContext.getAction());
        taskInstance.setState(taskState.name());
        taskInstance.setOperator(actionContext.getOperator());
        taskInstance.setRemark(actionContext.getRemark());
        UserTask userTask = (UserTask)actionContext.getTask();
        if (this.needForm(userTask, actionContext.getAction())) {
            Preconditions.checkNotNull((Object)actionContext.getForm(), (String)"form can't be null");
            Preconditions.checkTrue((boolean)actionContext.getForm().getClass().isAssignableFrom(userTask.getFormClass()), () -> "form type not match, should be class " + userTask.getFormClass());
            actionContext.getForm().validate();
            taskInstance.setFormData(JsonUtils.toJson((Object)actionContext.getForm()));
        } else {
            Preconditions.checkNull((Object)actionContext.getForm(), (String)"no form required");
        }
        taskInstance.setEndTime(new Date());
        taskInstance.setExt(this.handlerExt(actionContext, taskInstance.getExt()));
        this.workflowDataAccessor.taskInstanceStorage().update(taskInstance);
    }

    private boolean needForm(UserTask userTask, Action action) {
        if (userTask.getFormClass() == null) {
            return false;
        }
        return Action.APPROVE.equals((Object)action) || Action.COMPLETE.equals((Object)action);
    }

    private String handlerExt(WorkflowContext.ActionContext actionContext, String oldExt) {
        Map extMap = Optional.ofNullable(oldExt).map(e -> JsonUtils.parseMap((String)oldExt, String.class, Object.class)).orElseGet(Maps::newHashMap);
        if (Action.TRANSFER.equals((Object)actionContext.getAction())) {
            extMap.put("transferToUsers", actionContext.getTransferToUsers());
        }
        return JsonUtils.toJson((Object)extMap);
    }

    private TaskState toTaskState(Action action) {
        switch (action) {
            case APPROVE: {
                return TaskState.APPROVED;
            }
            case REJECT: {
                return TaskState.REJECTED;
            }
            case CANCEL: {
                return TaskState.CANCELED;
            }
            case TRANSFER: {
                return TaskState.TRANSFERED;
            }
            case TERMINATE: {
                return TaskState.TERMINATED;
            }
        }
        throw new WorkflowException("unknow action " + this);
    }

    private TaskEvent toTaskEvent(Action action) {
        switch (action) {
            case APPROVE: {
                return TaskEvent.APPROVE;
            }
            case REJECT: {
                return TaskEvent.REJECT;
            }
            case CANCEL: {
                return TaskEvent.CANCEL;
            }
            case TRANSFER: {
                return TaskEvent.TRANSFER;
            }
            case TERMINATE: {
                return TaskEvent.TERMINATE;
            }
        }
        throw new WorkflowException("unknow action " + this);
    }
}

