/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.processor;

import java.util.Date;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.workflow.core.WorkflowDataAccessor;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEventNotifier;
import org.apache.inlong.manager.workflow.core.impl.WorkflowEventNotifier;
import org.apache.inlong.manager.workflow.core.processor.AbstractNextableElementProcessor;
import org.apache.inlong.manager.workflow.model.Action;
import org.apache.inlong.manager.workflow.model.ProcessState;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.apache.inlong.manager.workflow.model.definition.Process;
import org.apache.inlong.manager.workflow.model.definition.ProcessForm;
import org.apache.inlong.manager.workflow.model.definition.StartEvent;
import org.apache.inlong.manager.workflow.model.instance.ProcessInstance;

public class StartEventProcessor
extends AbstractNextableElementProcessor<StartEvent> {
    private WorkflowDataAccessor workflowDataAccessor;
    private ProcessEventNotifier processEventNotifier;

    public StartEventProcessor(WorkflowDataAccessor workflowDataAccessor, WorkflowEventNotifier workflowEventNotifier) {
        this.workflowDataAccessor = workflowDataAccessor;
        this.processEventNotifier = workflowEventNotifier.getProcessEventNotifier();
    }

    @Override
    public Class<StartEvent> watch() {
        return StartEvent.class;
    }

    @Override
    public void create(StartEvent startEvent, WorkflowContext context) {
        String applicant = context.getApplicant();
        Process process = context.getProcess();
        ProcessForm form = context.getProcessForm();
        if (process.getFormClass() != null) {
            Preconditions.checkNotNull((Object)form, (String)"form can't be null");
            Preconditions.checkTrue((boolean)form.getClass().isAssignableFrom(process.getFormClass()), () -> "form type not match, should be class " + process.getFormClass());
            form.validate();
        } else {
            Preconditions.checkNull((Object)form, (String)"no form required");
        }
        ProcessInstance processInstance = this.createProcessInstance(applicant, process, form);
        context.setProcessInstance(processInstance);
        context.setActionContext(new WorkflowContext.ActionContext().setAction(Action.START));
    }

    @Override
    public boolean pendingForAction(WorkflowContext context) {
        return false;
    }

    @Override
    public boolean complete(WorkflowContext context) {
        this.processEventNotifier.notify(ProcessEvent.CREATE, context);
        return true;
    }

    private ProcessInstance createProcessInstance(String applicant, Process process, ProcessForm form) {
        ProcessInstance processInstance = new ProcessInstance().setName(process.getName()).setDisplayName(process.getDisplayName()).setType(process.getType()).setTitle(form.getTitle()).setBusinessId(form.getBusinessId()).setApplicant(applicant).setState(ProcessState.PROCESSING.name()).setFormData(JsonUtils.toJson((Object)form)).setStartTime(new Date()).setHidden(process.getHidden());
        this.workflowDataAccessor.processInstanceStorage().insert(processInstance);
        Preconditions.checkNotNull((Object)processInstance.getId(), (String)"process inst id cannot be null");
        return processInstance;
    }
}

