/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.processor;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.inlong.manager.workflow.core.WorkflowDataAccessor;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEventNotifier;
import org.apache.inlong.manager.workflow.core.impl.WorkflowEventNotifier;
import org.apache.inlong.manager.workflow.core.processor.WorkflowElementProcessor;
import org.apache.inlong.manager.workflow.exception.WorkflowException;
import org.apache.inlong.manager.workflow.model.Action;
import org.apache.inlong.manager.workflow.model.ProcessState;
import org.apache.inlong.manager.workflow.model.TaskState;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.apache.inlong.manager.workflow.model.definition.Element;
import org.apache.inlong.manager.workflow.model.definition.EndEvent;
import org.apache.inlong.manager.workflow.model.instance.ProcessInstance;
import org.apache.inlong.manager.workflow.model.instance.TaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class EndEventProcessor
implements WorkflowElementProcessor<EndEvent> {
    private static final Logger log = LoggerFactory.getLogger(EndEventProcessor.class);
    private WorkflowDataAccessor workflowDataAccessor;
    private ProcessEventNotifier processEventNotifier;

    public EndEventProcessor(WorkflowDataAccessor workflowDataAccessor, WorkflowEventNotifier workflowEventNotifier) {
        this.workflowDataAccessor = workflowDataAccessor;
        this.processEventNotifier = workflowEventNotifier.getProcessEventNotifier();
    }

    @Override
    public Class<EndEvent> watch() {
        return EndEvent.class;
    }

    @Override
    public void create(EndEvent element, WorkflowContext context) {
    }

    @Override
    public boolean pendingForAction(WorkflowContext context) {
        return false;
    }

    @Override
    public boolean complete(WorkflowContext context) {
        ProcessInstance processInstance = context.getProcessInstance();
        List<TaskInstance> pendingTasks = this.workflowDataAccessor.taskInstanceStorage().list(processInstance.getId(), TaskState.PENDING);
        if (!CollectionUtils.isEmpty(pendingTasks)) {
            log.warn("have pending task ,end event not execute");
            return true;
        }
        WorkflowContext.ActionContext actionContext = context.getActionContext();
        processInstance.setState(this.getProcessState(actionContext.getAction()).name());
        processInstance.setEndTime(new Date());
        this.workflowDataAccessor.processInstanceStorage().update(processInstance);
        this.processEventNotifier.notify(this.mapToEvent(actionContext.getAction()), context);
        return true;
    }

    @Override
    public List<Element> next(EndEvent element, WorkflowContext context) {
        return Collections.emptyList();
    }

    private ProcessState getProcessState(Action action) {
        switch (action) {
            case APPROVE: 
            case COMPLETE: {
                return ProcessState.COMPLETED;
            }
            case REJECT: {
                return ProcessState.REJECTED;
            }
            case CANCEL: {
                return ProcessState.CANCELED;
            }
            case TERMINATE: {
                return ProcessState.TERMINATED;
            }
        }
        throw new WorkflowException("unknow action " + (Object)((Object)action));
    }

    private ProcessEvent mapToEvent(Action action) {
        switch (action) {
            case APPROVE: 
            case COMPLETE: {
                return ProcessEvent.COMPLETE;
            }
            case REJECT: {
                return ProcessEvent.REJECT;
            }
            case CANCEL: {
                return ProcessEvent.CANCEL;
            }
            case TERMINATE: {
                return ProcessEvent.TERMINATE;
            }
        }
        throw new WorkflowException("unknow action " + (Object)((Object)action));
    }
}

