/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.processor;

import com.google.common.base.Joiner;
import java.util.Date;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.workflow.core.WorkflowDataAccessor;
import org.apache.inlong.manager.workflow.core.processor.AbstractNextableElementProcessor;
import org.apache.inlong.manager.workflow.core.processor.SkipAbleElementProcessor;
import org.apache.inlong.manager.workflow.model.TaskState;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.apache.inlong.manager.workflow.model.definition.ApproverAssign;
import org.apache.inlong.manager.workflow.model.definition.Element;
import org.apache.inlong.manager.workflow.model.definition.Task;
import org.apache.inlong.manager.workflow.model.instance.ProcessInstance;
import org.apache.inlong.manager.workflow.model.instance.TaskInstance;

public abstract class AbstractTaskProcessor<T extends Task>
extends AbstractNextableElementProcessor<T>
implements SkipAbleElementProcessor<T> {
    protected WorkflowDataAccessor workflowDataAccessor;

    public AbstractTaskProcessor(WorkflowDataAccessor workflowDataAccessor) {
        this.workflowDataAccessor = workflowDataAccessor;
    }

    @Override
    public void skip(T task, WorkflowContext context) {
        ProcessInstance processInstance = context.getProcessInstance();
        Date now = new Date();
        String operators = Joiner.on((String)",").join(ApproverAssign.DEFAULT_SKIP_APPROVER.assign(context));
        TaskInstance taskInstance = new TaskInstance().setType(task.getClass().getSimpleName()).setProcessInstId(processInstance.getId()).setProcessName(processInstance.getName()).setProcessDisplayName(processInstance.getDisplayName()).setApplicant(processInstance.getApplicant()).setApprovers(operators).setOperator(operators).setName(((Element)task).getName()).setDisplayName(((Element)task).getDisplayName()).setState(TaskState.SKIPPED.name()).setRemark("auto skipped").setStartTime(now).setEndTime(now);
        this.workflowDataAccessor.taskInstanceStorage().insert(taskInstance);
        Preconditions.checkNotNull((Object)taskInstance.getId(), (String)"task instance id cannot be null");
    }
}

