/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.processor;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.workflow.core.processor.WorkflowElementProcessor;
import org.apache.inlong.manager.workflow.exception.WorkflowException;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.apache.inlong.manager.workflow.model.definition.Element;
import org.apache.inlong.manager.workflow.model.definition.EndEvent;
import org.apache.inlong.manager.workflow.model.definition.NextableElement;
import org.springframework.util.CollectionUtils;

public abstract class AbstractNextableElementProcessor<T extends NextableElement>
implements WorkflowElementProcessor<T> {
    @Override
    public List<Element> next(T element, WorkflowContext context) {
        WorkflowContext.ActionContext actionContext = context.getActionContext();
        List<Element> nextElements = ((NextableElement)element).getNextList(actionContext.getAction(), context);
        Preconditions.checkNotEmpty(nextElements, (String)"not found next element ");
        Element endEvent = nextElements.stream().filter(ele -> ele instanceof EndEvent).findFirst().orElse(null);
        if (endEvent == null) {
            return nextElements;
        }
        List notEndEventElements = nextElements.stream().filter(ele -> !(ele instanceof EndEvent)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(notEndEventElements)) {
            return Collections.singletonList(endEvent);
        }
        throw new WorkflowException("process definition error, find endEvent and not endEvent at the same time");
    }
}

