/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.manager.workflow.core.TransactionHelper;
import org.apache.inlong.manager.workflow.core.WorkflowDataAccessor;
import org.apache.inlong.manager.workflow.core.WorkflowProcessorExecutor;
import org.apache.inlong.manager.workflow.core.impl.WorkflowEventNotifier;
import org.apache.inlong.manager.workflow.core.processor.EndEventProcessor;
import org.apache.inlong.manager.workflow.core.processor.ServiceTaskProcessor;
import org.apache.inlong.manager.workflow.core.processor.SkipAbleElementProcessor;
import org.apache.inlong.manager.workflow.core.processor.StartEventProcessor;
import org.apache.inlong.manager.workflow.core.processor.UserTaskProcessor;
import org.apache.inlong.manager.workflow.core.processor.WorkflowElementProcessor;
import org.apache.inlong.manager.workflow.exception.WorkflowException;
import org.apache.inlong.manager.workflow.exception.WorkflowNoRollbackException;
import org.apache.inlong.manager.workflow.exception.WorkflowRollbackOnceException;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.apache.inlong.manager.workflow.model.definition.Element;
import org.apache.inlong.manager.workflow.model.definition.NextableElement;
import org.apache.inlong.manager.workflow.model.definition.SkippableElement;
import org.apache.inlong.manager.workflow.model.definition.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionCallback;

public class WorkflowProcessorExecutorImpl
implements WorkflowProcessorExecutor {
    private static final Logger log = LoggerFactory.getLogger(WorkflowProcessorExecutorImpl.class);
    private final ImmutableMap<Class<? extends Element>, WorkflowElementProcessor> workflowElementProcessor;
    private TransactionHelper transactionHelper;

    public WorkflowProcessorExecutorImpl(WorkflowDataAccessor workflowDataAccessor, WorkflowEventNotifier workflowEventNotifier, TransactionHelper transactionHelper) {
        List<WorkflowElementProcessor<?>> processors = this.initProcessors(workflowDataAccessor, workflowEventNotifier);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        processors.forEach(processor -> builder.put(processor.watch(), processor));
        this.workflowElementProcessor = builder.build();
        this.transactionHelper = transactionHelper;
    }

    private List<WorkflowElementProcessor<?>> initProcessors(WorkflowDataAccessor workflowDataAccessor, WorkflowEventNotifier workflowEventNotifier) {
        ArrayList processors = Lists.newArrayList();
        processors.add(new StartEventProcessor(workflowDataAccessor, workflowEventNotifier));
        processors.add(new EndEventProcessor(workflowDataAccessor, workflowEventNotifier));
        processors.add(new UserTaskProcessor(workflowDataAccessor, workflowEventNotifier));
        processors.add(new ServiceTaskProcessor(workflowDataAccessor, workflowEventNotifier));
        return processors;
    }

    private WorkflowElementProcessor getProcessor(Class<? extends Element> elementClazz) {
        if (!this.workflowElementProcessor.containsKey(elementClazz)) {
            throw new WorkflowException("element executor not found " + elementClazz.getName());
        }
        return (WorkflowElementProcessor)this.workflowElementProcessor.get(elementClazz);
    }

    @Override
    public void executeStart(Element element, WorkflowContext context) {
        WorkflowElementProcessor processor = this.getProcessor(element.getClass());
        context.setCurrentElement(element);
        if (this.isSkipCurrentElement(element, context)) {
            this.executeSkipAndNext(element, context);
            return;
        }
        processor.create(element, context);
        if (processor.pendingForAction(context)) {
            return;
        }
        if (element instanceof Task) {
            this.transactionHelper.execute(this.executeCompleteInTransaction(element, context), 6);
            return;
        }
        this.executeComplete(element, context);
    }

    @Override
    public void executeComplete(Element element, WorkflowContext context) {
        WorkflowElementProcessor processor = this.getProcessor(element.getClass());
        context.setCurrentElement(element);
        boolean completed = processor.complete(context);
        if (!completed) {
            return;
        }
        List<Element> nextElements = processor.next(element, context);
        nextElements.forEach(next -> this.executeStart((Element)next, context));
    }

    private boolean isSkipCurrentElement(Element element, WorkflowContext context) {
        return element instanceof SkippableElement && ((SkippableElement)((Object)element)).isSkip(context);
    }

    private void executeSkipAndNext(Element element, WorkflowContext context) {
        if (!(element instanceof SkippableElement)) {
            throw new WorkflowException("element not instance of skipable element " + element.getDisplayName());
        }
        if (!(element instanceof NextableElement)) {
            throw new WorkflowException("element not instance of nextable element " + element.getDisplayName());
        }
        WorkflowElementProcessor processor = this.getProcessor(element.getClass());
        if (!(processor instanceof SkipAbleElementProcessor)) {
            throw new WorkflowException("element processor not instance of skipable processor " + element.getDisplayName());
        }
        ((SkipAbleElementProcessor)((Object)processor)).skip(element, context);
        context.getActionContext().setAction(((NextableElement)element).defaultNextAction());
        List<Element> nextElements = processor.next(element, context);
        nextElements.forEach(next -> this.executeStart((Element)next, context));
    }

    private TransactionCallback<Object> executeCompleteInTransaction(Element element, WorkflowContext context) {
        return s -> {
            try {
                this.executeComplete(element, context);
                return null;
            }
            catch (WorkflowNoRollbackException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WorkflowRollbackOnceException(e.getMessage());
            }
        };
    }
}

