/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.impl;

import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.workflow.core.EventListenerService;
import org.apache.inlong.manager.workflow.core.ProcessDefinitionService;
import org.apache.inlong.manager.workflow.core.ProcessService;
import org.apache.inlong.manager.workflow.core.QueryService;
import org.apache.inlong.manager.workflow.core.TaskService;
import org.apache.inlong.manager.workflow.core.TransactionHelper;
import org.apache.inlong.manager.workflow.core.WorkflowDataAccessor;
import org.apache.inlong.manager.workflow.core.WorkflowEngine;
import org.apache.inlong.manager.workflow.core.impl.EventListenerServiceImpl;
import org.apache.inlong.manager.workflow.core.impl.ProcessDefinitionServiceImpl;
import org.apache.inlong.manager.workflow.core.impl.ProcessServiceImpl;
import org.apache.inlong.manager.workflow.core.impl.QueryServiceImpl;
import org.apache.inlong.manager.workflow.core.impl.TaskServiceImpl;
import org.apache.inlong.manager.workflow.core.impl.WorkflowContextBuilderImpl;
import org.apache.inlong.manager.workflow.core.impl.WorkflowEventListenerManager;
import org.apache.inlong.manager.workflow.core.impl.WorkflowEventNotifier;
import org.apache.inlong.manager.workflow.core.impl.WorkflowInternalEventListenerRegister;
import org.apache.inlong.manager.workflow.core.impl.WorkflowProcessorExecutorImpl;
import org.apache.inlong.manager.workflow.model.WorkflowConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowEngineImpl
implements WorkflowEngine {
    private static final Logger log = LoggerFactory.getLogger(WorkflowEngineImpl.class);
    private ProcessDefinitionService processDefinitionService;
    private ProcessService processService;
    private TaskService taskService;
    private QueryService queryService;
    private EventListenerService eventListenerService;
    private WorkflowDataAccessor workflowDataAccessor;

    public WorkflowEngineImpl(WorkflowConfig workflowConfig) {
        log.info("start init workflow engine with config");
        if (log.isDebugEnabled()) {
            log.debug("config:{}", (Object)JsonUtils.toJson((Object)workflowConfig));
        }
        TransactionHelper transactionHelper = new TransactionHelper(workflowConfig.getPlatformTransactionManager());
        this.workflowDataAccessor = workflowConfig.getWorkflowDataAccessor();
        WorkflowEventListenerManager workflowEventListenerManager = new WorkflowEventListenerManager(workflowConfig);
        WorkflowEventNotifier workflowEventNotifier = new WorkflowEventNotifier(workflowEventListenerManager);
        WorkflowProcessorExecutorImpl workflowProcessorExecutor = new WorkflowProcessorExecutorImpl(this.workflowDataAccessor, workflowEventNotifier, transactionHelper);
        WorkflowContextBuilderImpl workflowContextBuilder = new WorkflowContextBuilderImpl(workflowConfig.getWorkflowDataAccessor());
        this.queryService = new QueryServiceImpl(workflowConfig.getWorkflowDataAccessor());
        this.processDefinitionService = new ProcessDefinitionServiceImpl(this.workflowDataAccessor);
        this.processService = new ProcessServiceImpl(workflowProcessorExecutor, workflowContextBuilder, this.workflowDataAccessor);
        this.taskService = new TaskServiceImpl(workflowProcessorExecutor, workflowContextBuilder);
        this.eventListenerService = new EventListenerServiceImpl(workflowConfig.getWorkflowDataAccessor(), workflowContextBuilder, workflowEventNotifier, workflowEventListenerManager);
        new WorkflowInternalEventListenerRegister(workflowConfig, workflowEventListenerManager, this.queryService).registerInternalEventListeners(workflowConfig, workflowEventListenerManager);
        log.info("success init workflow engine");
    }

    @Override
    public ProcessDefinitionService processDefinitionService() {
        return this.processDefinitionService;
    }

    @Override
    public ProcessService processService() {
        return this.processService;
    }

    @Override
    public TaskService taskService() {
        return this.taskService;
    }

    @Override
    public QueryService queryService() {
        return this.queryService;
    }

    @Override
    public EventListenerService eventListenerService() {
        return this.eventListenerService;
    }

    @Override
    public WorkflowDataAccessor workflowDataAccessor() {
        return this.workflowDataAccessor;
    }
}

