/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.impl;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.workflow.core.WorkflowContextBuilder;
import org.apache.inlong.manager.workflow.core.WorkflowDataAccessor;
import org.apache.inlong.manager.workflow.model.Action;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.apache.inlong.manager.workflow.model.definition.Process;
import org.apache.inlong.manager.workflow.model.definition.ProcessForm;
import org.apache.inlong.manager.workflow.model.definition.Task;
import org.apache.inlong.manager.workflow.model.definition.TaskForm;
import org.apache.inlong.manager.workflow.model.instance.ProcessInstance;
import org.apache.inlong.manager.workflow.model.instance.TaskInstance;
import org.apache.inlong.manager.workflow.util.WorkflowFormParserUtils;

public class WorkflowContextBuilderImpl
implements WorkflowContextBuilder {
    private WorkflowDataAccessor workflowDataAccessor;

    public WorkflowContextBuilderImpl(WorkflowDataAccessor workflowDataAccessor) {
        this.workflowDataAccessor = workflowDataAccessor;
    }

    @Override
    public WorkflowContext buildContextForProcess(String name, String applicant, ProcessForm form) {
        Process process = this.workflowDataAccessor.processDefinitionStorage().get(name);
        WorkflowContext context = new WorkflowContext();
        context.setProcess(process);
        context.setProcessForm(form);
        context.setApplicant(applicant);
        return context;
    }

    @Override
    public WorkflowContext buildContextForProcess(Integer processInstId) {
        ProcessInstance processInstance = this.workflowDataAccessor.processInstanceStorage().get(processInstId);
        Preconditions.checkNotNull((Object)processInstance, (String)("process not exist! " + processInstId));
        Process process = this.workflowDataAccessor.processDefinitionStorage().get(processInstance.getName());
        return new WorkflowContext().setApplicant(processInstance.getApplicant()).setProcess(process).setProcessForm((ProcessForm)WorkflowFormParserUtils.parseProcessForm(processInstance.getFormData(), process)).setProcessInstance(processInstance);
    }

    @Override
    public WorkflowContext buildContextForTask(Integer taskInstId, Action action, String remark, String operator) {
        return this.buildContextForTask(taskInstId, action, null, null, remark, operator);
    }

    @Override
    public WorkflowContext buildContextForTask(Integer taskInstId, Action action, TaskForm taskForm, String remark, String operator) {
        return this.buildContextForTask(taskInstId, action, taskForm, null, remark, operator);
    }

    @Override
    public WorkflowContext buildContextForTask(Integer taskInstId, Action action, List<String> transferToUsers, String remark, String operator) {
        return this.buildContextForTask(taskInstId, action, null, transferToUsers, remark, operator);
    }

    @Override
    public WorkflowContext buildContextForTask(Integer taskInstId, Action action) {
        TaskInstance taskInstance = this.workflowDataAccessor.taskInstanceStorage().get(taskInstId);
        Process process = this.workflowDataAccessor.processDefinitionStorage().get(taskInstance.getProcessName());
        Object taskForm = WorkflowFormParserUtils.parseTaskForm(taskInstance, process);
        List<String> transferToUsers = this.getTransferToUsers(taskInstance.getExt());
        return this.buildContextForTask(taskInstId, action, (TaskForm)taskForm, transferToUsers, taskInstance.getRemark(), taskInstance.getOperator());
    }

    private WorkflowContext buildContextForTask(Integer taskInstId, Action action, TaskForm taskForm, List<String> transferToUsers, String remark, String operator) {
        TaskInstance taskInstance = this.workflowDataAccessor.taskInstanceStorage().get(taskInstId);
        Preconditions.checkNotNull((Object)taskInstance, (String)("task not exist , taskId is " + taskInstId));
        ProcessInstance processInstance = this.workflowDataAccessor.processInstanceStorage().get(taskInstance.getProcessInstId());
        Process process = this.workflowDataAccessor.processDefinitionStorage().get(processInstance.getName());
        Object processForm = WorkflowFormParserUtils.parseProcessForm(processInstance.getFormData(), process);
        Task task = process.getTaskByName(taskInstance.getName());
        return new WorkflowContext().setProcess(process).setApplicant(processInstance.getApplicant()).setProcessForm((ProcessForm)processForm).setProcessInstance(processInstance).setCurrentElement(task).setActionContext(new WorkflowContext.ActionContext().setAction(action).setActionTaskInstance(taskInstance).setTask(task).setForm(taskForm).setTransferToUsers(transferToUsers).setOperator(operator).setRemark(remark));
    }

    private List<String> getTransferToUsers(String ext) {
        if (StringUtils.isEmpty((CharSequence)ext)) {
            return Lists.newArrayList();
        }
        Map extMap = JsonUtils.parseMap((String)ext, String.class, Object.class);
        if (!extMap.containsKey("transferToUsers")) {
            return Lists.newArrayList();
        }
        if (extMap.get("transferToUsers") instanceof List) {
            return (List)extMap.get("transferToUsers");
        }
        return null;
    }
}

