/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.impl;

import java.util.List;
import org.apache.inlong.manager.workflow.core.TaskService;
import org.apache.inlong.manager.workflow.core.WorkflowContextBuilder;
import org.apache.inlong.manager.workflow.core.WorkflowProcessorExecutor;
import org.apache.inlong.manager.workflow.model.Action;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.apache.inlong.manager.workflow.model.definition.TaskForm;

public class TaskServiceImpl
implements TaskService {
    private WorkflowProcessorExecutor workflowProcessorExecutor;
    private WorkflowContextBuilder workflowContextBuilder;

    public TaskServiceImpl(WorkflowProcessorExecutor workflowProcessorExecutor, WorkflowContextBuilder workflowContextBuilder) {
        this.workflowProcessorExecutor = workflowProcessorExecutor;
        this.workflowContextBuilder = workflowContextBuilder;
    }

    @Override
    public WorkflowContext approve(Integer taskId, String remark, TaskForm form, String operator) {
        WorkflowContext context = this.workflowContextBuilder.buildContextForTask(taskId, Action.APPROVE, form, remark, operator);
        this.workflowProcessorExecutor.executeComplete(context.getActionContext().getTask(), context);
        return context;
    }

    @Override
    public WorkflowContext reject(Integer taskId, String remark, String operator) {
        WorkflowContext context = this.workflowContextBuilder.buildContextForTask(taskId, Action.REJECT, remark, operator);
        this.workflowProcessorExecutor.executeComplete(context.getActionContext().getTask(), context);
        return context;
    }

    @Override
    public WorkflowContext transfer(Integer taskId, String remark, List<String> to, String operator) {
        WorkflowContext context = this.workflowContextBuilder.buildContextForTask(taskId, Action.TRANSFER, to, remark, operator);
        this.workflowProcessorExecutor.executeComplete(context.getActionContext().getTask(), context);
        return context;
    }

    @Override
    public WorkflowContext complete(Integer taskId, String remark, String operator) {
        WorkflowContext context = this.workflowContextBuilder.buildContextForTask(taskId, Action.COMPLETE, remark, operator);
        this.workflowProcessorExecutor.executeComplete(context.getActionContext().getTask(), context);
        return context;
    }
}

