/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.impl;

import java.util.List;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.workflow.core.ProcessService;
import org.apache.inlong.manager.workflow.core.WorkflowContextBuilder;
import org.apache.inlong.manager.workflow.core.WorkflowDataAccessor;
import org.apache.inlong.manager.workflow.core.WorkflowProcessorExecutor;
import org.apache.inlong.manager.workflow.model.Action;
import org.apache.inlong.manager.workflow.model.TaskState;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.apache.inlong.manager.workflow.model.definition.ProcessForm;
import org.apache.inlong.manager.workflow.model.definition.Task;
import org.apache.inlong.manager.workflow.model.instance.TaskInstance;

public class ProcessServiceImpl
implements ProcessService {
    private WorkflowProcessorExecutor workflowProcessorExecutor;
    private WorkflowContextBuilder workflowContextBuilder;
    private WorkflowDataAccessor workflowDataAccessor;

    public ProcessServiceImpl(WorkflowProcessorExecutor workflowProcessorExecutor, WorkflowContextBuilder workflowContextBuilder, WorkflowDataAccessor workflowDataAccessor) {
        this.workflowProcessorExecutor = workflowProcessorExecutor;
        this.workflowContextBuilder = workflowContextBuilder;
        this.workflowDataAccessor = workflowDataAccessor;
    }

    @Override
    public WorkflowContext start(String name, String applicant, ProcessForm form) {
        Preconditions.checkNotEmpty((String)name, (String)"process name cannot be null");
        Preconditions.checkNotEmpty((String)applicant, (String)"applicant cannot be null");
        Preconditions.checkNotNull((Object)form, (String)"form cannot be null");
        WorkflowContext context = this.workflowContextBuilder.buildContextForProcess(name, applicant, form);
        this.workflowProcessorExecutor.executeStart(context.getProcess().getStartEvent(), context);
        return context;
    }

    @Override
    public WorkflowContext cancel(Integer processInstId, String operator, String remark) {
        Preconditions.checkNotEmpty((String)operator, (String)"operator cannot be null");
        Preconditions.checkNotNull((Object)processInstId, (String)"processInstId cannot be null");
        WorkflowContext context = this.workflowContextBuilder.buildContextForProcess(processInstId);
        List<TaskInstance> pendingTasks = this.workflowDataAccessor.taskInstanceStorage().list(processInstId, TaskState.PENDING);
        for (TaskInstance taskInstance : pendingTasks) {
            Task task = context.getProcess().getTaskByName(taskInstance.getName());
            context.setActionContext(new WorkflowContext.ActionContext().setAction(Action.CANCEL).setActionTaskInstance(taskInstance).setOperator(operator).setRemark(remark).setTask(task));
            this.workflowProcessorExecutor.executeComplete(task, context);
        }
        return context;
    }
}

