/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.workflow.core.ProcessDefinitionStorage;
import org.apache.inlong.manager.workflow.exception.WorkflowException;
import org.apache.inlong.manager.workflow.model.definition.Process;

public class MemoryProcessDefinitionStorage
implements ProcessDefinitionStorage {
    private static final Map<String, Process> PROCESS_BY_NAME_STORAGE = Maps.newConcurrentMap();

    @Override
    public Process get(String name) {
        if (!PROCESS_BY_NAME_STORAGE.containsKey(name)) {
            return null;
        }
        try {
            return PROCESS_BY_NAME_STORAGE.get(name).clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new WorkflowException();
        }
    }

    @Override
    public void add(Process process) {
        Preconditions.checkNotEmpty((String)process.getName(), (String)"process name cannot be null");
        if (PROCESS_BY_NAME_STORAGE.containsKey(process.getName())) {
            throw new WorkflowException("process already exist with the same name " + process.getName());
        }
        PROCESS_BY_NAME_STORAGE.put(process.getName(), process);
    }

    @Override
    public void delete(String name) {
        if (!PROCESS_BY_NAME_STORAGE.containsKey(name)) {
            throw new WorkflowException("process definition not found for name " + name);
        }
        PROCESS_BY_NAME_STORAGE.remove(name);
    }
}

